/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import java.util.ArrayList;

public class ProcessStatistics
implements IProcessMonitor {
    private IProcessSearchService service;

    public ProcessStatistics(IProcessSearchService service) {
        this.service = service;
    }

    @Override
    public int getRunning() {
        ArrayList<ProcessStatus> list = new ArrayList<ProcessStatus>();
        list.add(ProcessStatus.CREATED);
        list.add(ProcessStatus.RUNNING);
        list.add(ProcessStatus.BUSY);
        return this.service.count(list);
    }

    @Override
    public int getPaused() {
        return this.service.count(ProcessStatus.PAUSED);
    }

    @Override
    public int getQueued() {
        return this.service.count(ProcessStatus.QUEUED);
    }

    @Override
    public int getBranched() {
        return this.service.count(ProcessStatus.BRANCHED);
    }

    @Override
    public int getCancelled() {
        return this.service.count(ProcessStatus.CANCELLED);
    }

    @Override
    public int getCreated() {
        return 0;
    }

    @Override
    public int getFailed() {
        return this.service.count(ProcessStatus.ERROR);
    }

    @Override
    public int getCompleted() {
        return this.service.count(ProcessStatus.COMPLETED);
    }

    @Override
    public double getCreateRate() {
        return 0.0;
    }

    @Override
    public int getCreateRatePerMinute() {
        return 0;
    }

    @Override
    public double getMaxCreateRate() {
        return 0.0;
    }

    @Override
    public int getMaxCreateRatePerMinute() {
        return 0;
    }

    @Override
    public int getRestarted() {
        return 0;
    }

    @Override
    public void setMaxCreateRate(double rate) {
        throw new UnsupportedOperationException();
    }
}

