/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph.exe;

import java.io.StringReader;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jbpm.JbpmException;
import org.jbpm.instantiation.FieldInstantiator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FieldConfigInstantiator
extends FieldInstantiator {
    private static final Logger logger = Logger.getLogger(FieldConfigInstantiator.class);
    private static final ThreadLocal<XMLReader> xmlReader = new ThreadLocal<XMLReader>(){

        @Override
        protected XMLReader initialValue() {
            return new SAXParser();
        }
    };

    public Object instantiate(Class clazz, String configuration) {
        Object newInstance = this.newInstance(clazz);
        if (configuration != null && !"".equals(configuration)) {
            List list = this.parseConfiguration(configuration).elements();
            for (Element propertyElement : list) {
                this.setPropertyValue(clazz, newInstance, propertyElement.getName(), propertyElement);
            }
        }
        return newInstance;
    }

    public Element parseConfiguration(String configuration) {
        Element element = null;
        try {
            element = this.parseText("<action>" + configuration + "</action>").getRootElement();
        }
        catch (Exception e) {
            logger.error((Object)("couldn't parse bean configuration : " + configuration), (Throwable)e);
            throw new JbpmException((Throwable)e);
        }
        return element;
    }

    private Document parseText(String text) throws DocumentException, SAXException {
        Document result = null;
        SAXReader reader = new SAXReader();
        InputSource source = new InputSource(new StringReader(text));
        reader.setXMLReader(this.getXmlReader());
        result = reader.read(source);
        return result;
    }

    private XMLReader getXmlReader() throws SAXException {
        XMLReader reader = xmlReader.get();
        ((SAXParser)reader).reset();
        return reader;
    }
}

