/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.graph.IUndoableNode;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.graph.node.Fork;
import org.jbpm.logging.log.ProcessLog;

public class ExtendedFork
extends Fork
implements IUndoableNode {
    private static final long serialVersionUID = 2146745869571244953L;
    private static final Logger logger = Logger.getLogger(ExtendedFork.class);
    public static final String TOKEN_NAME_SEPARATOR = "|";

    public ExtendedFork() {
    }

    public ExtendedFork(String name) {
        super(name);
    }

    public void execute(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        if (!token.isRoot()) {
            throw new InvalidProcessStateException(token + " cannot spawn children");
        }
        logger.info((Object)(token + " (" + this.name + ")"));
        ArrayList<CustomToken> childTokens = new ArrayList<CustomToken>();
        for (Transition transition : this.getLeavingTransitions()) {
            String transitionName = transition.getName();
            logger.debug((Object)(token + " creating token for transition " + transitionName));
            String name = String.valueOf(transitionName) + TOKEN_NAME_SEPARATOR + System.currentTimeMillis();
            childTokens.add(new CustomToken(token, name));
        }
        token.fork();
        token.addLog((ProcessLog)new NodeLog((Node)this, token.getNodeEnter(), new Date()));
        for (CustomToken childToken : childTokens) {
            childToken.start();
        }
    }

    public void leave(ExecutionContext context) {
        String name = context.getToken().getName();
        String transitionName = name.substring(0, name.indexOf(TOKEN_NAME_SEPARATOR));
        Transition transition = null;
        for (Object obj : this.leavingTransitions) {
            Transition t = (Transition)obj;
            if (!transitionName.equals(t.getName())) continue;
            transition = t;
            break;
        }
        super.leave(context, transition);
    }

    public Transition addLeavingTransition(Transition leavingTransition) {
        if (leavingTransition.getName() == null) {
            throw new RuntimeException("Fork (" + this.name + ") must have named transitions");
        }
        return super.addLeavingTransition(leavingTransition);
    }

    @Override
    public void undo(ExecutionContext context) {
    }

    @Override
    public boolean canUndo() {
        return true;
    }
}

