/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.entities;

import java.io.Serializable;

public enum ResourceState implements Serializable
{
    INITIALIZING(1),
    ONLINE(2),
    OFFLINE(3),
    INITIALIZATION_ERROR(4),
    HEARTBEAT_ERROR(5),
    ERROR(6),
    INACTIVE(7),
    INVALID(8);

    private final int stateId;

    private ResourceState(int id) {
        this.stateId = id;
    }

    public String toString() {
        return this.getStateName();
    }

    public int getId() {
        return this.stateId;
    }

    public String getStateName() {
        String displayName = null;
        switch (this) {
            case INITIALIZING: {
                displayName = "Initializing";
                break;
            }
            case ONLINE: {
                displayName = "Online";
                break;
            }
            case OFFLINE: {
                displayName = "Offline";
                break;
            }
            case INITIALIZATION_ERROR: {
                displayName = "Initialization Error";
                break;
            }
            case HEARTBEAT_ERROR: {
                displayName = "HeartBeat Error";
                break;
            }
            case ERROR: {
                displayName = "Error";
                break;
            }
            case INACTIVE: {
                displayName = "Inactive";
                break;
            }
            case INVALID: {
                displayName = "Invalid";
            }
        }
        return displayName;
    }

    public static ResourceState getById(Integer stateId) {
        if (stateId != null) {
            ResourceState[] resourceStateArray = ResourceState.values();
            int n = resourceStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceState state = resourceStateArray[n2];
                if (state.getId() == stateId.intValue()) {
                    return state;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isError() {
        boolean result = false;
        switch (this) {
            case INITIALIZATION_ERROR: 
            case HEARTBEAT_ERROR: 
            case ERROR: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }
}

