/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.internal;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.AdaptorRuntimeException;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.conf.IMessageProcessorConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.IDispatcher;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.IHandler;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.adaptor.messageidentifier.WPCLMessageIdentifier;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractDefaultAdaptor
implements IAdaptor {
    private List<IMessageIdentifier> messageIDClasses;
    Logger logger = Logger.getLogger(AbstractDefaultAdaptor.class);

    protected AbstractDefaultAdaptor() {
        this.messageIDClasses = new ArrayList<IMessageIdentifier>();
        this.addMessageIDClass((IMessageIdentifier)new WPCLMessageIdentifier());
    }

    protected abstract IMessageProcessorConfiguration getConfiguration(IMessageUID var1);

    protected abstract void addConfiguration(IMessageUID var1, IMessageProcessorConfiguration var2);

    protected abstract IHandler getHandler(IMessageProcessorConfiguration var1) throws HandlerException;

    protected abstract IDispatcher getDispatcher(IMessageProcessorConfiguration var1, IDestination var2) throws DispatcherException;

    protected abstract List<IDestination> getDestinations(IAdaptorRequest var1, IMessageUID var2);

    protected abstract IAdaptorResponse createDefaultResponse(IAdaptorRequest var1);

    protected IMessage transmit(IMessage msg, IDestination dst, IMessageUID uid) throws DispatcherException, HandlerException {
        IMessageProcessorConfiguration conf = this.getConfiguration(uid);
        IHandler handler = this.getHandler(conf);
        IMessage converted = handler.process(msg);
        IDispatcher dispatcher = this.getDispatcher(conf, dst);
        IMessage response = dispatcher.send(converted);
        IMessage ret = handler.postProcess(response);
        return ret;
    }

    public IAdaptorResponse transmit(IAdaptorRequest request) throws AdaptorException {
        if (request == null) {
            throw new AdaptorRuntimeException("Request must not be null");
        }
        IMessageUID uid = this.getMessageUID(request.getMessage());
        if (uid == null) {
            throw new AdaptorException("Failed to determine the UID of this request");
        }
        IAdaptorResponse response = this.createDefaultResponse(request);
        List<IDestination> destinations = this.getDestinations(request, uid);
        for (IDestination destination : destinations) {
            try {
                IMessage ret = this.transmit(request.getMessage(), destination, uid);
                response.addMessage(ret, destination);
            }
            catch (DispatcherException e) {
                throw new AdaptorException("Couldn't send the message", (Throwable)e);
            }
            catch (HandlerException e) {
                throw new AdaptorException("Message translation failed", (Throwable)e);
            }
        }
        return response;
    }

    public void addMessageIDClass(IMessageIdentifier msgIdentifier) {
        for (IMessageIdentifier identifier : this.messageIDClasses) {
            if (!identifier.getClass().getName().equals(msgIdentifier.getClass().getName())) continue;
            return;
        }
        this.messageIDClasses.add(0, msgIdentifier);
    }

    protected IMessageUID getMessageUID(IMessage message) {
        for (IMessageIdentifier identifier : this.messageIDClasses) {
            IMessageUID uid = null;
            try {
                uid = identifier.identify(message);
            }
            catch (Exception ex) {
                this.logger.warn((Object)("Class " + identifier.getClass().getName() + " failed to determine message uid"), (Throwable)ex);
            }
            if (uid == null) continue;
            return uid;
        }
        return null;
    }
}

