/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

class HostAddress {
    HostAddress() {
    }

    public static boolean match() {
        try {
            URL url = new URL(ApplicationProperties.getInstance().getProperty("cms.application.url"));
            String addr = url.getHost();
            return HostAddress.getHostAddresses().contains(addr);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<String> getHostAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip instanceof Inet6Address) continue;
                    addresses.add(ip.getHostAddress());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return addresses;
    }
}

