/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogReaderFilenameFilter
implements FilenameFilter {
    private List<String> types;
    private Set<Long> nodeIds;

    public LogReaderFilenameFilter(List<String> types, Set<Long> nodeIds) {
        this.types = types;
        this.nodeIds = nodeIds;
    }

    @Override
    public boolean accept(File dir, String name) {
        Pattern pattern = Pattern.compile(LogReaderFilenameFilter.getLogReaderFilenameRegex(this.types), 2);
        Matcher matcher = pattern.matcher(name);
        while (matcher.find()) {
            if (!this.nodeIds.contains(Long.parseLong(matcher.group(1)))) continue;
            return true;
        }
        return false;
    }

    public static String getLogReaderFilenameRegex(List<String> typeNames) {
        String regex = ".*-(\\d+)-(" + LogReaderFilenameFilter.buildTypeRegex(typeNames) + ")" + "$";
        return regex;
    }

    private static String buildTypeRegex(List<String> typeNames) {
        StringBuilder sb = new StringBuilder();
        for (String type : typeNames) {
            sb.append(type);
            sb.append("|");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

