/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.template.ExtendedJpdlXmlReader;
import com.tandbergtv.workflow.exe.resource.ReleaseResource;
import com.tandbergtv.workflow.exe.resource.RequestResource;
import com.tandbergtv.workflow.exe.resource.SetResource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.Criteria;
import org.hibernate.classic.Session;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;

public class WFSJpdlXmlReader
extends ExtendedJpdlXmlReader {
    private static final long serialVersionUID = 582032965130984683L;
    private List<ResourceGroup> groups;
    private static Map<String, Class<?>> map = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("resource-release", ReleaseResource.class);
            this.put("resource-request", RequestResource.class);
            this.put("set-resource", SetResource.class);
        }
    };
    private static final Logger logger = Logger.getLogger(WFSJpdlXmlReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WFSJpdlXmlReader() {
        try (Session session = null;){
            session = HibernateUtil.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(ResourceGroup.class);
            this.groups = criteria.list();
        }
    }

    public Map<String, String> getPredefinedActions() {
        HashMap<String, String> actions = new HashMap<String, String>();
        for (String key : map.keySet()) {
            actions.put(key, map.get(key).getName());
        }
        return actions;
    }

    public void readNode(Element nodeElement, Node node, NodeCollection nodeCollection) {
        if (!(node instanceof ResourceGroupAware)) {
            return;
        }
        Element child = nodeElement.element("resource-group");
        if (child != null) {
            this.readResourceGroup(child, node);
        }
    }

    protected void readResourceGroup(Element element, Node node) {
        String name = element.attributeValue("name");
        boolean found = false;
        for (ResourceGroup group : this.groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            found = true;
            logger.debug((Object)("Found resource group " + group.getId() + " for " + name));
            if (!(node instanceof ResourceGroupAware)) break;
            ((ResourceGroupAware)node).setResourceGroupID(Long.valueOf(group.getId()));
            break;
        }
        if (!found) {
            this.addError("Failed to find resource group " + name + " at node " + node.getName());
        }
    }
}

