/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.license;

import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.license.ILicenseProvider;
import com.tandbergtv.workflow.license.ILicenseProviderService;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;

public class LicenseProviderService
implements ILicenseProviderService {
    private static final Logger logger = Logger.getLogger(LicenseProviderService.class);
    public static final String SERVICE_NAME = "License Provider Service";
    private static final String LICENSE_PROVIDER_EXTENSION_POINT = "licenseProvider";
    private static final String LICENSE_PLUGIN = "com.tandbergtv.workflow.license";
    private ILicenseProvider provider;

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        logger.info((Object)"LicenseProviderService started");
    }

    public void stop() {
        logger.info((Object)"LicenseProviderService stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILicenseProvider getLicenseProvider() {
        if (this.provider != null) {
            return this.provider;
        }
        LicenseProviderService licenseProviderService = this;
        synchronized (licenseProviderService) {
            if (this.provider != null) {
                return this.provider;
            }
            this.init();
        }
        return this.provider;
    }

    private void init() {
        PluginManager pm = Platform.getPlatform().getPluginManager();
        ExtensionPoint point = null;
        try {
            point = pm.getRegistry().getExtensionPoint(LICENSE_PLUGIN, LICENSE_PROVIDER_EXTENSION_POINT);
        }
        catch (Exception e) {
            logger.error((Object)"Error loading plugin: com.tandbergtv.workflow.license", (Throwable)e);
            return;
        }
        ILicenseProvider pvdr = null;
        if (!point.getAvailableExtensions().isEmpty()) {
            Extension extension = (Extension)point.getAvailableExtensions().iterator().next();
            String className = extension.getParameter("class").valueAsString();
            PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
            try {
                Class clazz = pm.getPluginClassLoader(desc).loadClass(className);
                pvdr = (ILicenseProvider)clazz.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("Error loading license info from plugin: " + className), (Throwable)e);
            }
        }
        this.provider = pvdr;
    }
}

