/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.WPCLValidationException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WPCLValidator {
    private static final String XSD_PATH = "com/tandbergtv/workflow/message/wpcl.xsd";
    private static Schema schema;
    private static final ThreadLocal<DocumentBuilder> b;
    private static final ThreadLocal<Transformer> tf;
    private static final ThreadLocal<Validator> v;

    static {
        InputStream stream = WPCLValidator.class.getClassLoader().getResourceAsStream(XSD_PATH);
        try {
            schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(stream));
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        b = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                try {
                    return DocumentBuilderFactory.newInstance().newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new Error();
                }
            }
        };
        tf = new ThreadLocal<Transformer>(){

            @Override
            protected Transformer initialValue() {
                try {
                    return TransformerFactory.newInstance().newTransformer();
                }
                catch (TransformerException e) {
                    throw new Error();
                }
            }
        };
        v = new ThreadLocal<Validator>(){

            @Override
            protected Validator initialValue() {
                return schema.newValidator();
            }
        };
    }

    private WPCLValidator() {
    }

    public static WPCLValidator newInstance() {
        return new WPCLValidator();
    }

    public void validate(Document document) throws WPCLValidationException {
        try {
            this.getValidator().validate(new DOMSource(document));
        }
        catch (Exception e) {
            throw new WPCLValidationException("WPCL validation failed", e);
        }
    }

    public void validate(WorkflowMessage message) throws WPCLValidationException {
        Document document = null;
        try {
            Document doc = Marshaller.newMarshaller().marshal(message);
            String xml = this.convertToString(doc);
            document = this.loadXml(xml);
        }
        catch (MarshalException e) {
            throw new WPCLValidationException("Failed to marshal the message to WPCL", e);
        }
        catch (Exception e) {
            throw new WPCLValidationException("Failed to load the message into XML", e);
        }
        this.validate(document);
    }

    public Schema getSchema() throws Exception {
        return schema;
    }

    private String convertToString(Node node) throws Exception {
        Document document;
        StringWriter w = new StringWriter();
        Transformer transformer = this.getTransformer();
        Document document2 = document = node instanceof Document ? (Document)Document.class.cast(node) : node.getOwnerDocument();
        if (document.getXmlEncoding() != null) {
            transformer.setOutputProperty("encoding", document.getXmlEncoding());
        }
        transformer.transform(new DOMSource(node), new StreamResult(w));
        return w.getBuffer().toString();
    }

    private Document loadXml(String xml) throws Exception {
        return this.getDocumentBuilder().parse(new InputSource(new StringReader(xml)));
    }

    private Transformer getTransformer() {
        Transformer transformer = tf.get();
        transformer.reset();
        return transformer;
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder = b.get();
        builder.reset();
        return builder;
    }

    private Validator getValidator() {
        Validator validator = v.get();
        validator.reset();
        return validator;
    }
}

