/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlarmNotificationService
implements IAlarmNotificationService {
    private Set<IAlarmNotificationProvider> providers;
    private Map<String, Long> totalTimeTaken = new HashMap<String, Long>();
    private Map<String, Long> callCounters = new HashMap<String, Long>();

    public AlarmNotificationService() {
        this.providers = new HashSet<IAlarmNotificationProvider>();
    }

    @Override
    public List<AlarmNotification> getAlarms(long timestamp) {
        Calendar dateCutoff = Calendar.getInstance();
        dateCutoff.setTimeInMillis(timestamp);
        ArrayList<AlarmNotification> alarms = new ArrayList<AlarmNotification>();
        for (IAlarmNotificationProvider provider : this.providers) {
            alarms.addAll(provider.getAlarms(dateCutoff));
        }
        return alarms;
    }

    @Override
    public void addProvider(IAlarmNotificationProvider provider) {
        this.providers.add(provider);
        this.callCounters.put(provider.getClass().getSimpleName(), 0L);
        this.totalTimeTaken.put(provider.getClass().getSimpleName(), 0L);
    }

    @Override
    public void removeProvider(IAlarmNotificationProvider provider) {
        this.providers.remove(provider);
        this.callCounters.remove(provider.getClass().getSimpleName());
        this.totalTimeTaken.remove(provider.getClass().getSimpleName());
    }

    public void start() {
    }

    public void stop() {
        this.providers.clear();
        this.callCounters.clear();
        this.totalTimeTaken.clear();
    }

    public String getServiceName() {
        return "alarm-notifications";
    }
}

