/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import java.util.HashMap;
import java.util.Map;

public class ProcessStatusStatistics
implements IProcessMonitor {
    private final Map<ProcessStatus, Integer> statistics = new HashMap<ProcessStatus, Integer>();

    public ProcessStatusStatistics(Map<ProcessStatus, Integer> statistics) {
        if (statistics != null) {
            this.statistics.putAll(statistics);
        }
        int activeCount = this.getCount(ProcessStatus.CREATED) + this.getCount(ProcessStatus.RUNNING) + this.getCount(ProcessStatus.BUSY);
        this.statistics.put(ProcessStatus.ACTIVE, activeCount);
    }

    public int getCount(ProcessStatus status) {
        Integer count = this.statistics.get(status);
        return count != null ? count : 0;
    }

    @Override
    public int getCreated() {
        return this.getCount(ProcessStatus.CREATED);
    }

    @Override
    public int getRestarted() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPaused() {
        return this.getCount(ProcessStatus.PAUSED);
    }

    @Override
    public int getCancelled() {
        return this.getCount(ProcessStatus.CANCELLED);
    }

    @Override
    public int getQueued() {
        return this.getCount(ProcessStatus.QUEUED);
    }

    @Override
    public int getCompleted() {
        return this.getCount(ProcessStatus.COMPLETED);
    }

    @Override
    public int getFailed() {
        return this.getCount(ProcessStatus.ERROR);
    }

    @Override
    public int getBranched() {
        return this.getCount(ProcessStatus.BRANCHED);
    }

    @Override
    public int getRunning() {
        return this.getCount(ProcessStatus.ACTIVE);
    }

    @Override
    public double getCreateRate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCreateRatePerMinute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getMaxCreateRate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxCreateRate(double rate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxCreateRatePerMinute() {
        throw new UnsupportedOperationException();
    }
}

