/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.thread.DistributedCallable;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class SuspendCallable
implements DistributedCallable<Void>,
Serializable {
    private static final long serialVersionUID = 882656670124527786L;

    public Object getKey() {
        return null;
    }

    public Void call() throws Exception {
        Logger.getLogger(SuspendCallable.class).info((Object)"Suspending...");
        this.setIsHalted(true);
        IDistributedCache<WorkflowProcess> cache = this.getCache();
        IProcessManagerService service = this.getService();
        ISchedulerService<CustomToken> scheduler = this.getScheduler();
        final IProcessCounter counter = (IProcessCounter)((Object)service.getStatistics().getCumulativeStatistics());
        for (Serializable id : cache.localKeySet()) {
            WorkflowProcess process = (WorkflowProcess)cache.get(id);
            final CustomToken token = process.getRootToken();
            if (!process.getCanBePaused()) continue;
            scheduler.schedule((Callable)new Callable<CustomToken>(){

                @Override
                public CustomToken call() throws Exception {
                    token.suspend();
                    counter.paused(token);
                    return token;
                }
            });
        }
        return null;
    }

    protected ISchedulerService<CustomToken> getScheduler() {
        return this.getService().getScheduler();
    }

    protected IDistributedCache<WorkflowProcess> getCache() {
        return (IDistributedCache)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    protected IProcessManagerService getService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    protected void setIsHalted(boolean isHalted) {
        Logger logger = Logger.getLogger(SuspendCallable.class);
        IProcessManagerService service = this.getService();
        Properties properties = service.getProperties();
        properties.setProperty("isDriverHalted", Boolean.toString(isHalted));
        try {
            properties.store((OutputStream)null, (String)null);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to save the halted state", (Throwable)e);
        }
    }
}

