/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.internal.monitor.ManualTaskAlarmNotification;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessAlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenericAlarmNotificationProvider
implements IAlarmNotificationProvider {
    private static final Logger logger = Logger.getLogger(GenericAlarmNotificationProvider.class);
    private static final int MAX_NUMBER_OF_ALERTS = 1000;
    public static final String ALARM_RECOVERY_URL = "/workflow/process/";
    public static final String CHILD_PROCESS_ERROR_MSG_PREFIX = "alarms.childProcess.error.prefix";
    private ProcessAlarmNotification processAlarmNotificationBuilder = new ProcessAlarmNotification();
    private ManualTaskAlarmNotification manualTaskAlarmNotificationBuilder = new ManualTaskAlarmNotification();

    public final Set<AlarmNotification> getAlarms(Calendar dateCutoff) {
        HashSet<AlarmNotification> set = new HashSet<AlarmNotification>();
        ICacheService<WorkflowProcess> cache = this.getCache();
        logger.debug((Object)("Searching Process Cache size of " + cache.getKeys().size()));
        for (Serializable key : cache.getKeys()) {
            WorkflowProcess process = (WorkflowProcess)cache.get(key);
            if (process == null) continue;
            boolean foundError = false;
            boolean foundManualTasks = false;
            for (CustomToken token : process.findAllTokens()) {
                if (!foundError && this.processAlarmNotificationBuilder.match(token, dateCutoff)) {
                    AlarmNotification alarm = this.processAlarmNotificationBuilder.buildAlarm(process);
                    if (alarm != null) {
                        set.add(alarm);
                    }
                } else if (!foundManualTasks && this.manualTaskAlarmNotificationBuilder.match(token, dateCutoff)) {
                    set.addAll(this.manualTaskAlarmNotificationBuilder.buildAlarmsForProcess(process));
                    foundManualTasks = true;
                }
                if (foundError && foundManualTasks) break;
            }
            if (set.size() >= 1000) break;
        }
        logger.debug((Object)("Found " + set.size() + " process alarms"));
        return set;
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }
}

