/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessStatusStatistics;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.search.ISearchHelper;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.TemplateParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class WorkflowProcessSearchHelper
implements ISearchHelper {
    private SessionFactory factory;
    private static final Logger logger = Logger.getLogger(WorkflowProcessSearchHelper.class);
    private static final String PROCESS_ALIAS = "process";
    private static final String WORKFLOW_TEMPLATE_ALIAS = "template";
    private static final String ORDER_BY = " ORDER BY ";
    private static final String NON_ARCHIVED_WHERE_CLAUSE = " AND process.active = true";
    private static final String WORKORDER_TEMPLATE_WHERE_CLAUSE = "process.processDefinition.id = template.id";
    private static final String STATISTICS_GROUP_CLAUSE = " GROUP BY process.status";

    public WorkflowProcessSearchHelper(SessionFactory factory) {
        this.factory = factory;
    }

    @Override
    public List<WorkflowProcess> search(SearchCriteria searchCriteria) {
        List<WorkflowProcess> processes = null;
        try (Session session = this.factory.openSession();){
            String queryString = this.buildQuery(searchCriteria, QueryType.DEFAULT);
            logger.debug((Object)("Executing search query:" + queryString));
            if (queryString != null) {
                Query query = session.createQuery(queryString);
                if (searchCriteria.getStartingRecordNumber() != 0) {
                    query.setFirstResult(searchCriteria.getStartingRecordNumber());
                }
                if (searchCriteria.getRecordsCount() != 0) {
                    query.setMaxResults(searchCriteria.getRecordsCount());
                }
                List queryResult = query.list();
                processes = this.getProcessListFromQueryResult(queryResult);
            }
            logger.debug((Object)("Search Result:" + processes.size() + " Processes"));
        }
        return processes;
    }

    @Override
    public int count(SearchCriteria searchCriteria) {
        int count = 0;
        try (Session session = this.factory.openSession();){
            String queryString = this.buildQuery(searchCriteria, QueryType.COUNT);
            if (queryString != null) {
                logger.debug((Object)("Executing count query:" + queryString));
                List queryResult = session.createQuery(queryString).list();
                count = ((Number)queryResult.get(0)).intValue();
                logger.debug((Object)("Received count:" + count));
            }
        }
        return count;
    }

    @Override
    public IProcessMonitor statistics(SearchCriteria searchCriteria) {
        ProcessStatusStatistics statistics = null;
        try (Session session = this.factory.openSession();){
            String queryString = this.buildQuery(searchCriteria, QueryType.STATISTICS);
            if (queryString != null) {
                logger.debug((Object)("Executing statistics query:" + queryString));
                List queryResult = session.createQuery(queryString).list();
                HashMap<ProcessStatus, Integer> data = new HashMap<ProcessStatus, Integer>();
                for (Object row : queryResult) {
                    Object[] rowValues = (Object[])row;
                    ProcessStatus status = (ProcessStatus)rowValues[0];
                    int count = ((Number)rowValues[1]).intValue();
                    data.put(status, count);
                }
                statistics = new ProcessStatusStatistics(data);
            }
        }
        return statistics;
    }

    private List<WorkflowProcess> getProcessListFromQueryResult(List<?> queryResult) {
        ArrayList<WorkflowProcess> processes = new ArrayList<WorkflowProcess>();
        for (Object objects : queryResult) {
            WorkflowProcess process = null;
            process = objects instanceof WorkflowProcess ? (WorkflowProcess)objects : (WorkflowProcess)((Object[])objects)[0];
            processes.add(process);
        }
        return processes;
    }

    private String buildQuery(SearchCriteria searchCriteria, QueryType queryType) {
        StringBuilder query = new StringBuilder(256);
        this.buildFromClause(searchCriteria, queryType, query);
        String fromClause = query.toString();
        query.setLength(0);
        this.buildSelectClause(searchCriteria, queryType, query);
        query.append(fromClause);
        this.buildWhereClause(searchCriteria, queryType, query);
        this.buildOrderClause(searchCriteria, queryType, query);
        return query.toString();
    }

    private void buildSelectClause(SearchCriteria searchCriteria, QueryType queryType, StringBuilder queryBuffer) {
        queryBuffer.append("SELECT ");
        if (QueryType.STATISTICS.equals((Object)queryType)) {
            queryBuffer.append(PROCESS_ALIAS);
            queryBuffer.append(".status, ");
        }
        if (!QueryType.DEFAULT.equals((Object)queryType)) {
            queryBuffer.append("COUNT(");
        }
        if (searchCriteria.isSearchDistinct()) {
            queryBuffer.append("DISTINCT ");
        }
        queryBuffer.append(PROCESS_ALIAS);
        if (QueryType.DEFAULT.equals((Object)queryType)) {
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (param.getSortingOrder() == null) continue;
                if (param.isVarInstance()) {
                    queryBuffer.append(", ").append(param.getAlias());
                    continue;
                }
                if (param.getFieldName().indexOf(".") == -1) continue;
                queryBuffer.append(", ").append(param.getAlias());
                queryBuffer.append(".").append(param.getFieldName());
            }
        } else {
            queryBuffer.append(")");
        }
    }

    private void buildFromClause(SearchCriteria searchCriteria, QueryType queryType, StringBuilder queryBuffer) {
        queryBuffer.append(" FROM WorkflowProcess ").append(PROCESS_ALIAS);
        int objectCount = 1;
        if (queryType.equals((Object)QueryType.DEFAULT)) {
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (!param.isVarInstance() || !(param instanceof SortParameter)) continue;
                queryBuffer.append(param.getPartialFromClause(objectCount++));
            }
        }
        String templateClassName = null;
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            String fromPart;
            if (param.isVarInstance() && param instanceof SortParameter) continue;
            if (param instanceof TemplateParameter) {
                templateClassName = ((TemplateParameter)param).getClassName();
                continue;
            }
            if ((fromPart = param.getPartialFromClause(objectCount++)).length() > 0) {
                queryBuffer.append(", ");
            }
            queryBuffer.append(fromPart);
        }
        if (templateClassName == null) {
            templateClassName = this.getDefaultTemplateClass().getName();
        }
        queryBuffer.append(", ");
        queryBuffer.append(templateClassName).append(" ").append(WORKFLOW_TEMPLATE_ALIAS);
    }

    private Class<?> getDefaultTemplateClass() {
        return WorkflowTemplate.class;
    }

    private void buildWhereClause(SearchCriteria searchCriteria, QueryType queryType, StringBuilder queryBuffer) {
        boolean firstCondition = true;
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            String partialWhere;
            if (param instanceof TemplateParameter || (partialWhere = param.getPartialWhereClause()).equals("")) continue;
            queryBuffer.append(firstCondition ? " WHERE " : " AND ");
            queryBuffer.append(partialWhere);
            firstCondition = false;
        }
        queryBuffer.append(firstCondition ? " WHERE " : " AND ");
        queryBuffer.append(WORKORDER_TEMPLATE_WHERE_CLAUSE);
        queryBuffer.append(NON_ARCHIVED_WHERE_CLAUSE);
    }

    private void buildOrderClause(SearchCriteria searchCriteria, QueryType queryType, StringBuilder queryBuffer) {
        if (QueryType.DEFAULT.equals((Object)queryType)) {
            boolean firstParameter = true;
            for (SearchParameterBase param : searchCriteria.getSearchList()) {
                if (param.getSortingOrder() == null) continue;
                queryBuffer.append(firstParameter ? ORDER_BY : ", ");
                queryBuffer.append(param.getAlias()).append(".").append(param.getSortingColumn());
                String order = param.getSortingOrder() == SortingOrder.ASCENDING ? " ASC" : " DESC";
                queryBuffer.append(order);
                firstParameter = false;
            }
        } else if (QueryType.STATISTICS.equals((Object)queryType)) {
            queryBuffer.append(STATISTICS_GROUP_CLAUSE);
        }
    }

    private static enum QueryType {
        DEFAULT,
        COUNT,
        STATISTICS;

    }
}

