/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.internal;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.IArchivalStrategy;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.node.ProcessState;

public class VersionBasedArchivalStrategy
implements IArchivalStrategy {
    private static final Logger logger = Logger.getLogger(VersionBasedArchivalStrategy.class);
    private ITemplateLoaderService loader;
    private IProcessSearchService search;

    public VersionBasedArchivalStrategy(ITemplateLoaderService loader, IProcessSearchService search) {
        this.loader = loader;
        this.search = search;
    }

    @Override
    public void archive() {
        for (WorkflowTemplate template : this.loader.getLatestTemplates()) {
            this.archive(template);
        }
    }

    @Override
    public void archive(WorkflowTemplate template) {
        logger.info((Object)("Trying to delete older versions of template " + template));
        for (WorkflowTemplate previous : this.loader.getPreviousVersions(template)) {
            if (this.isSubProcess(previous)) continue;
            int count = this.search.count(previous, ProcessStatus.BRANCHED, ProcessStatus.BUSY, ProcessStatus.CANCELLED, ProcessStatus.COMPLETED, ProcessStatus.CREATED, ProcessStatus.ERROR, ProcessStatus.PAUSED, ProcessStatus.QUEUED, ProcessStatus.RUNNING);
            logger.info((Object)("Found " + count + " process(es) of template " + previous));
            try {
                if (count != 0) continue;
                this.loader.delete(previous);
            }
            catch (DriverException e) {
                logger.warn((Object)("Failed to delete older versions of template " + template), (Throwable)e);
            }
        }
    }

    private boolean isSubProcess(WorkflowTemplate template) {
        List<WorkflowTemplate> templates = this.loader.getAllTemplates();
        for (WorkflowTemplate t : templates) {
            if (t.equals((Object)template)) continue;
            for (Node node : t.getNodes()) {
                ProcessState p;
                if (!(node instanceof ProcessState) || !(p = (ProcessState)ProcessState.class.cast(node)).getSubProcessDefinition().equals((Object)template)) continue;
                logger.info((Object)(template + " is used by " + t));
                return true;
            }
        }
        return false;
    }
}

