/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.IntegrityCheckReport;

public final class ResourceTypeExtensionValidator {
    private ResourceTypeExtensionValidator() {
    }

    public static List<String> validate(Extension extension, IntegrityCheckReport report) {
        ArrayList<String> result = new ArrayList<String>();
        ResourceTypeExtensionValidator.validateExtension(extension, report, result);
        if (result.size() == 0) {
            ResourceTypeExtensionValidator.validateCommunication(extension, result);
        }
        return result;
    }

    private static void validateExtension(Extension extension, IntegrityCheckReport report, List<String> result) {
        if (!extension.isValid()) {
            result.add("The Plugin Extension has failed framework validation.");
            for (IntegrityCheckReport.ReportItem item : report.getItems()) {
                if (item.getSeverity() != IntegrityCheckReport.Severity.ERROR) continue;
                String sourceId = item.getSource() != null ? item.getSource().getId() : null;
                String pluginId = extension.getDeclaringPluginDescriptor().getId();
                String extensionId = extension.getId();
                if (!extensionId.equals(sourceId) && !pluginId.equals(sourceId)) continue;
                result.add(item.getMessage());
            }
        }
    }

    private static void validateCommunication(Extension extension, List<String> result) {
        Extension.Parameter param = extension.getParameter("communication");
        if (param != null) {
            ResourceTypeExtensionValidator.validateAdaptor(param.getSubParameter("adaptor"), result);
            ResourceTypeExtensionValidator.validateMessageUIDs(param.getSubParameter("messages"), result);
        }
    }

    private static void validateAdaptor(Extension.Parameter parameter, List<String> result) {
        boolean isDefault;
        Extension.Parameter customParam = parameter.getSubParameter("custom");
        Extension.Parameter defaultParam = parameter.getSubParameter("default");
        boolean isCustom = customParam != null;
        boolean bl = isDefault = defaultParam != null;
        if (isCustom == isDefault) {
            if (isCustom) {
                String msg = "The Adaptor configuration cannot contain both 'default' and 'custom' parameters.";
                result.add(msg);
            } else {
                String msg = "The Adaptor configuration must contain one of 'default' or 'custom' parameters.";
                result.add(msg);
            }
        }
    }

    private static void validateMessageUIDs(Extension.Parameter parameter, List<String> result) {
        Collection messageParams = parameter.getSubParameters("message");
        ArrayList<String> uidValues = new ArrayList<String>();
        ArrayList<String> duplicates = new ArrayList<String>();
        for (Extension.Parameter messageParam : messageParams) {
            Extension.Parameter uidParam = messageParam.getSubParameter("uid");
            String uid = uidParam.valueAsString();
            if (uidValues.contains(uid) && !duplicates.contains(uid)) {
                duplicates.add(uid);
            }
            uidValues.add(uid);
        }
        for (String uid : duplicates) {
            result.add("The Message UID: " + uid + " is not uniquely assigned to a message.");
        }
    }
}

