/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class ServiceLifecycleListener
implements Service,
IColleague {
    private final ConcurrentMap<String, Set<String>> services = new ConcurrentHashMap<String, Set<String>>();
    private static final String NAME = "lifecycle-listener";
    private static final Logger logger = Logger.getLogger(ServiceLifecycleListener.class);

    public void addDependencyFor(String name, String dependent) {
        this.services.putIfAbsent(name, new CopyOnWriteArraySet());
        ((Set)this.services.get(name)).add(dependent);
    }

    @Override
    public String getServiceName() {
        return NAME;
    }

    @Override
    public void start() {
        DefaultMediator.getInstance().register((IColleague)this);
    }

    @Override
    public void stop() {
        DefaultMediator.getInstance().unregister((IColleague)this);
        this.services.clear();
    }

    public String getColleagueName() {
        return NAME;
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(WorkflowEvent e) {
        if (!(e instanceof ServiceEvent)) {
            return;
        }
        ServiceEvent event = (ServiceEvent)((Object)ServiceEvent.class.cast(e));
        logger.debug((Object)(String.valueOf(event.getService().getServiceName()) + " " + (Object)((Object)event.getEvent())));
        if (event.getEvent() == ServiceEvents.STARTED) {
            Set<Service> set = this.getDependentServices(event.getService());
            ServiceRegistry registry = ServiceRegistry.getDefault();
            for (Service service : set) {
                String name = service.getServiceName();
                if (registry.lookup(name) != null) {
                    logger.warn((Object)("Service " + name + ", " + service.getClass() + " is already registered"));
                    continue;
                }
                registry.register(name, service);
                service.start();
            }
        }
    }

    private Set<Service> getDependentServices(Service service) {
        Set names = (Set)this.services.get(service.getClass().getName());
        if (names == null) {
            names = (Set)this.services.get(service.getServiceName());
        }
        if (names == null) {
            return Collections.emptySet();
        }
        HashSet<Service> set = new HashSet<Service>();
        for (String name : names) {
            Service s = this.createService(name);
            if (s != null) {
                set.add(s);
            }
            logger.debug((Object)(String.valueOf(service.getServiceName()) + " <- " + name));
        }
        return set;
    }

    private Service createService(String clazz) {
        try {
            return (Service)this.getClass().getClassLoader().loadClass(clazz).newInstance();
        }
        catch (Throwable e) {
            logger.warn((Object)("Failed to create service lazily: " + clazz), e);
            return null;
        }
    }
}

