/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.loggers;

import com.tandbergtv.workflow.log.entities.ProcessQueuedPerResourceLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.loggers.AbstractLogger;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import java.util.EventObject;
import org.hibernate.SessionFactory;
import org.jbpm.logging.log.ProcessLog;

public class ProcessStatusPerResourceLogger
extends AbstractLogger {
    public ProcessStatusPerResourceLogger(SessionFactory sessionFactory, Integer count) {
        super(sessionFactory, count);
    }

    @Override
    public boolean match(EventObject logEvent, int index) {
        if (!(logEvent instanceof WorkflowProcessStatusLogEvent)) {
            return false;
        }
        WorkflowProcessStatusLogEvent event = (WorkflowProcessStatusLogEvent)WorkflowProcessStatusLogEvent.class.cast(logEvent);
        return event.getToken().getProcessInstance().getId() % (long)this.count == (long)index;
    }

    @Override
    public void execute(EventObject eventObj) {
        WorkflowProcessStatusLogEvent event = (WorkflowProcessStatusLogEvent)eventObj;
        if (!event.isTrace()) {
            return;
        }
        this.save(this.convertToProcessStatusLog(event));
    }

    private ProcessLog convertToProcessStatusLog(WorkflowProcessStatusLogEvent statusEvent) {
        ProcessStatusPerResourceLog pl = null;
        pl = statusEvent.isQueued() ? new ProcessQueuedPerResourceLog(statusEvent.getToken(), statusEvent.getNode(), statusEvent.getResourceGroup(), statusEvent.getResource(), statusEvent.getStartTime(), statusEvent.getEndTime(), statusEvent.getOperationalStatus(), statusEvent.getAdminStatus()) : new ProcessStatusPerResourceLog(statusEvent.getToken(), statusEvent.getNode(), statusEvent.getResourceGroup(), statusEvent.getResource(), statusEvent.getStartTime(), statusEvent.getEndTime(), statusEvent.getOperationalStatus(), statusEvent.getAdminStatus());
        return pl;
    }
}

