/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.resource;

import com.tandbergtv.workflow.auth.IUserProvider;
import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.internal.AuthorizationManager;
import com.tandbergtv.workflow.driver.service.IAuthorizationManager;
import com.tandbergtv.workflow.log.file.ResourceEventHistoryRemover;
import com.tandbergtv.workflow.monitor.Observers;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.IRecorder;
import com.tandbergtv.workflow.resource.sanity.HumanResourceSanityService;
import com.tandbergtv.workflow.resource.sanity.IHumanResourceSanityService;
import com.tandbergtv.workflow.resource.scan.HumanResourceScanService;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.util.resource.InternalResourceService;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.management.ManagementService;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class Activator {
    private static final Logger LOGGER = Logger.getLogger(Activator.class);
    private static final String SETTINGS_GROUP = "com.tandbergtv.workflow.application";
    private static final String PERIOD = "history.resourceEvent.retention.days";
    private static final String RESOURCE_TYPE_IDS = "com.tandbergtv.workflow.resource.systemids";
    private static final String DEFAULT_SYSTEM_IDS = "CM,PM,re,SM,ut,CG,ct,fs";
    private static final int DEFAULT_HISTORY_PERIOD = 7;
    private static final String MBEAN_QUERY = "com.tandbergtv.watchpoint:type=Queue,*";
    private static final String UI_PLUGIN_NAME = "com.tandbergtv.workflow.ui";
    private static final String USER_PROVIDER_EXTENSION_POINT = "users";

    public void start() {
        ManagementService.registerMBeans((CacheManager)CacheManager.getInstance(), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        SessionFactory factory = HibernateUtil.getSessionFactory();
        this.addService((Service)new AuthorizationManager(factory));
        String systemIds = null;
        int period = 7;
        ISettingsProvider provider = new SettingsPluginLoader().createSettingsProvider();
        if (provider != null) {
            Map<String, String> settings = provider.getProperties(SETTINGS_GROUP);
            systemIds = settings.get(RESOURCE_TYPE_IDS) == null ? DEFAULT_SYSTEM_IDS : settings.get(RESOURCE_TYPE_IDS);
            period = settings.get(PERIOD) == null ? period : Integer.parseInt(settings.get(PERIOD));
        }
        this.addService((Service)this.scheduleResourceEventHistoryRemover(period));
        this.addService((Service)new ResourceManager(factory, Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.addService((Service)new InternalResourceService(this.getResourceTypes(systemIds)));
        IUserProvider userProvider = this.getUserProvider();
        HumanResourceSanityService humanResourceSanityService = new HumanResourceSanityService();
        humanResourceSanityService.setUserProvider(userProvider);
        this.addService(humanResourceSanityService);
        HumanResourceScanService humanResourceScanService = new HumanResourceScanService();
        humanResourceScanService.setDelay(30000L);
        this.addService((Service)humanResourceScanService);
        this.addObserver();
    }

    public void stop() {
        this.removeService("resource-event-log-delete");
        this.removeService(HumanResourceScanService.class);
        this.removeService(IHumanResourceSanityService.class);
        this.removeService(ResourceManagement.class);
        this.removeService(IInternalResourceService.class);
        this.removeService(IAuthorizationManager.class);
        CacheManager.getInstance().shutdown();
    }

    private ISchedulerService<Void> scheduleResourceEventHistoryRemover(int period) {
        Scheduler scheduler = new Scheduler("resource-event-log-delete", 1, 1);
        scheduler.schedule((Runnable)new ResourceEventHistoryRemover(period), 0L, TimeUnit.DAYS.toMillis(1L));
        return scheduler;
    }

    private Collection<String> getResourceTypes(String property) {
        if (property == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(property.split(","));
    }

    private void addObserver() {
        IRecorder recorder = (IRecorder)ServiceRegistry.getDefault().lookup("fs-recorder");
        IRecorder logRecorder = (IRecorder)ServiceRegistry.getDefault().lookup("log-recorder");
        try {
            IObserver observer = Observers.localJMXObserver((String)MBEAN_QUERY, (String)"Size");
            recorder.addObserver(observer);
            logRecorder.addObserver(Observers.localJMXObserver((String)MBEAN_QUERY, (String)"Size"));
        }
        catch (JMException e) {
            Logger.getLogger(Activator.class).warn((Object)":(", (Throwable)e);
        }
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = this.getService(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void removeService(String name) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = ServiceRegistry.getDefault().lookup(name);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private IUserProvider getUserProvider() {
        Collection<Extension> extensions;
        PluginManager pluginManager = Platform.getPlatform().getPluginManager();
        try {
            extensions = this.getUserProviderExtensions(pluginManager);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"It wasn't possible to load the User Provider extension.", (Throwable)e);
            return null;
        }
        if (extensions.size() == 0) {
            LOGGER.debug((Object)"No User Provider plugin defined.");
            return null;
        }
        if (extensions.size() > 1) {
            LOGGER.warn((Object)"More than one User Provider specified. The first one will be used. Check the plugins configuration.");
        }
        Extension firstExtension = extensions.iterator().next();
        return this.getUserProviderInstance(pluginManager, firstExtension);
    }

    private Collection<Extension> getUserProviderExtensions(PluginManager pluginManager) throws PluginLifecycleException {
        PluginRegistry pluginRegistry = pluginManager.getRegistry();
        pluginManager.getPlugin(UI_PLUGIN_NAME);
        ExtensionPoint extentionPoint = pluginRegistry.getExtensionPoint(UI_PLUGIN_NAME, USER_PROVIDER_EXTENSION_POINT);
        Collection extensions = extentionPoint.getAvailableExtensions();
        return extensions;
    }

    private IUserProvider getUserProviderInstance(PluginManager pluginManager, Extension extension) {
        PluginDescriptor plugin = extension.getDeclaringPluginDescriptor();
        PluginClassLoader loader = pluginManager.getPluginClassLoader(plugin);
        try {
            Class<?> pluginClass = loader.loadClass(extension.getParameter("class").valueAsString());
            return (IUserProvider)pluginClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"It wasn't possible to load the User Provider plugin.", (Throwable)e);
            return null;
        }
    }
}

