/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.selector;

import com.tandbergtv.workflow.driver.message.selector.DefaultTemplateSelector;
import com.tandbergtv.workflow.driver.message.selector.TemplateSelectorClassLoadException;
import com.tandbergtv.workflow.messageprocessor.templateselector.ITemplateSelector;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.ClientExtensionClassLoader;

public class TemplateSelectorFactory {
    private TemplateSelectorFactory() {
    }

    public static TemplateSelectorFactory createInstance() {
        return new TemplateSelectorFactory();
    }

    public ITemplateSelector getTemplateSelector(String className) throws TemplateSelectorClassLoadException {
        if (className == null || className.length() == 0) {
            return new DefaultTemplateSelector();
        }
        ITemplateSelector selector = null;
        try {
            String dir = ApplicationProperties.getInstance().getProperty("clientClassesDirectory");
            ClientExtensionClassLoader loader = new ClientExtensionClassLoader(dir, this.getClass().getClassLoader());
            Class<?> clazz = loader.loadClass(className);
            Object obj = clazz.newInstance();
            selector = (ITemplateSelector)obj;
        }
        catch (Exception e) {
            throw new TemplateSelectorClassLoadException("Failed to load the selector class: " + className, e);
        }
        return selector;
    }
}

