/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.resource;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.event.ReleaseResourceEvent;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.exe.ExecutionContext;

public class ReleaseResource
implements ActionHandler {
    private static final String ALLOCATED_RESOURCE = "_allocated_resource_";
    private static final Logger LOGGER = Logger.getLogger(ReleaseResource.class);
    private static final long serialVersionUID = 2457819245589204128L;

    public void execute(ExecutionContext ec) throws Exception {
        if (!this.needsResource(ec)) {
            return;
        }
        CustomToken token = (CustomToken)ec.getToken();
        Node node = this.getResourceGroupAwareNode(ec);
        this.clearResourceAllocationKey(ec);
        String name = "_resource_" + token.getId();
        ContextInstance c = token.getProcessInstance().getContextInstance();
        if (!(node instanceof ResourceGroupAware)) {
            throw new ActionException(token + " cannot release resource for this node: " + node.getName());
        }
        Long resourceGroupId = ((ResourceGroupAware)node).getResourceGroupID();
        Resource resource = (Resource)c.getTransientVariable(name);
        if (resource != null) {
            LOGGER.info((Object)(token + " node (" + node.getName() + ") releasing resource " + resource));
        } else {
            LOGGER.info((Object)(token + " node (" + node.getName() + ") releasing resource"));
        }
        DefaultMediator.getInstance().send((WorkflowEvent)new ReleaseResourceEvent((Object)this, token, node, resourceGroupId, resource));
        c.deleteTransientVariable(name);
        c.deleteTransientVariable("_task_assigner_" + token.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearResourceAllocationKey(ExecutionContext ec) {
        String defaultVariableName = "_resource_host";
        String variableName = defaultVariableName + "_" + ec.getToken().getId();
        WorkflowProcess process = (WorkflowProcess)ec.getProcessInstance();
        String name = ALLOCATED_RESOURCE + ec.getToken().getId();
        Node node = this.getResourceGroupAwareNode(ec);
        process.lock();
        try {
            String current;
            ContextInstance ci = process.getContextInstance();
            String value = (String)ci.getTransientVariable(name);
            if (value != null) {
                ci.setVariable(name, (Object)value);
                ci.deleteTransientVariable(name);
            }
            if (ci.getVariable(variableName) != null) {
                ci.setVariable(variableName, null);
            }
            if (ci.getVariable(defaultVariableName) != null) {
                ci.setVariable(defaultVariableName, null);
            }
            if (ci.getVariable(current = "_current_resource_" + node.getName() + ec.getToken().getId()) != null) {
                LOGGER.debug((Object)(ec.getToken() + " deleting " + current));
                ci.setVariable(current, null);
            }
        }
        finally {
            process.unlock();
        }
    }

    private boolean needsResource(ExecutionContext context) {
        Node node = this.getResourceGroupAwareNode(context);
        Long resourceGroupId = ((ResourceGroupAware)node).getResourceGroupID();
        if (resourceGroupId == null) {
            return false;
        }
        IInternalResourceService service = (IInternalResourceService)ServiceRegistry.getDefault().lookup(IInternalResourceService.class);
        return service.needsResource(resourceGroupId.longValue()) && (!Boolean.getBoolean("com.tandbergtv.workflow.resourcemanager.consumertrace.disable") || context.getNode() instanceof ManualTaskNode);
    }

    private Node getResourceGroupAwareNode(ExecutionContext context) {
        Node node = context.getTransitionSource();
        if (node == null) {
            node = context.getToken().getNode();
        }
        Node parent = node;
        while (parent.getSuperState() instanceof SuperState) {
            if (!((parent = parent.getSuperState()) instanceof NodeGroup)) continue;
            return parent;
        }
        return node;
    }
}

