/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.file.Deserializer;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.LogReader;
import com.tandbergtv.workflow.log.file.LogReaderFilenameFilter;
import com.tandbergtv.workflow.log.file.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jbpm.logging.log.ProcessLog;

public class FileLogReader {
    private static final Logger LOGGER = Logger.getLogger(LogReader.class);
    private String root;

    public FileLogReader(String root) {
        this.root = root;
    }

    public int count(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds) {
        if (!this.hasLogs(id)) {
            return 0;
        }
        File dir = Directories.directoryFor(this.root, id);
        int count = 0;
        try {
            if (this.zipFile(id).exists()) {
                count = ZipUtil.count(this.zipFile(id), id, types, nodeIds);
            } else {
                String[] files = dir.list(new LogReaderFilenameFilter(FileLogReader.getSimpleNameList(types), nodeIds));
                count = files.length;
            }
        }
        catch (Throwable t) {
            LOGGER.warn((Object)("Failed to read logs for [" + id + "]"), t);
            return count;
        }
        return count;
    }

    public List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types) {
        if (!this.hasLogs(id)) {
            return Collections.emptyList();
        }
        List<Object> list = new ArrayList();
        try {
            list = this.zipFile(id).exists() ? ZipUtil.read(this.zipFile(id)) : this.read(id);
            this.sort(list);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ProcessLog log = (ProcessLog)i.next();
                if (types.contains(log.getClass())) continue;
                i.remove();
            }
            return list;
        }
        catch (Throwable t) {
            LOGGER.warn((Object)("Failed to read logs for [" + id + "]"), t);
            return Collections.emptyList();
        }
    }

    public List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds, int start, int count, boolean descending) {
        if (!this.hasLogs(id)) {
            return Collections.emptyList();
        }
        List<Object> list = new ArrayList();
        try {
            list = this.zipFile(id).exists() ? ZipUtil.read(this.zipFile(id), types, nodeIds, start, count, descending) : this.read(id, types, nodeIds, start, count, descending);
            return list;
        }
        catch (Throwable t) {
            LOGGER.warn((Object)("Failed to read logs for [" + id + "]"), t);
            return Collections.emptyList();
        }
    }

    public static List<String> getSimpleNameList(Collection<Class<? extends ProcessLog>> types) {
        ArrayList<String> simpleNameList = new ArrayList<String>();
        for (Class<? extends ProcessLog> log : types) {
            simpleNameList.add(log.getSimpleName());
        }
        return simpleNameList;
    }

    private List<ProcessLog> read(long id) {
        File[] files = Directories.directoryFor(this.root, id).listFiles();
        if (files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProcessLog> list = new ArrayList<ProcessLog>();
        for (File file : files) {
            ProcessLog log = new Deserializer(file).deserialize();
            if (log == null) continue;
            list.add(log);
        }
        return list;
    }

    private List<ProcessLog> read(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds, int start, int count, boolean descending) {
        File[] files = Directories.directoryFor(this.root, id).listFiles(new LogReaderFilenameFilter(FileLogReader.getSimpleNameList(types), nodeIds));
        if (files.length == 0) {
            return Collections.emptyList();
        }
        this.sort(files, descending);
        ArrayList<ProcessLog> list = new ArrayList<ProcessLog>();
        int end = files.length - start < count ? files.length : start + count;
        for (File file : Arrays.copyOfRange(files, start, end)) {
            ProcessLog log = null;
            if (file != null) {
                log = new Deserializer(file).deserialize();
            }
            if (log == null) continue;
            list.add(log);
        }
        return list;
    }

    private void sort(List<ProcessLog> list) {
        Collections.sort(list, new Comparator<ProcessLog>(){

            @Override
            public int compare(ProcessLog o1, ProcessLog o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
    }

    private void sort(File[] files, boolean descending) {
        if (descending) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return file2.getName().compareTo(file1.getName());
                }
            });
        } else {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return file1.getName().compareTo(file2.getName());
                }
            });
        }
    }

    private File zipFile(long id) {
        return new File(Directories.directoryFor(this.root, id), id + ".zip");
    }

    private boolean hasLogs(long id) {
        File f = Directories.directoryFor(this.root, id);
        return f.exists() && f.isDirectory();
    }
}

