/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.email;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.exe.email.IEmailService;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class Mail
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static final String MAIL_PROPERTIES_NAME = "mail.properties";
    private static final Logger LOGGER = Logger.getLogger(Mail.class);
    private String to;
    private String subject;
    private String text;
    private String attachment;
    private ExecutionContext executionContext;
    private IEmailService emailService;

    public Mail() {
    }

    public Mail(String to, String subject, String attachment, String text) {
        this.to = to;
        this.subject = subject;
        this.text = text;
        this.attachment = attachment;
    }

    public List<String> getRecipients() {
        ArrayList<String> recipients = new ArrayList<String>();
        if (this.to != null) {
            String resolvedTo = this.evaluate(this.to);
            recipients.addAll(this.tokenize(resolvedTo, ":;"));
        }
        return recipients;
    }

    public List<String> getAttachments() {
        String attachmentsEval = this.evaluate(this.attachment);
        List<String> attachments = this.tokenize(attachmentsEval, ";,");
        return attachments;
    }

    public String getSubject() {
        if (this.subject == null) {
            return null;
        }
        return this.evaluate(this.subject);
    }

    public String getText() {
        if (this.text == null) {
            return null;
        }
        return this.evaluate(this.text);
    }

    public void execute(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.send(this.getRecipients(), this.getSubject(), this.getText(), this.getAttachments());
    }

    protected void send(List<String> recipients, String subject, String text, List<String> attachments) {
        if (recipients == null || recipients.isEmpty()) {
            return;
        }
        String addresses = this.getAddresses(recipients);
        try {
            Session session = this.getEmailService().getSession();
            if (session == null) {
                throw new MessagingException("cannot send email, not session available");
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom();
            for (String recipient : recipients) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            }
            if (subject != null) {
                message.setSubject(subject);
            }
            MimeMultipart multipart = new MimeMultipart();
            if (text != null) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setText(text);
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            for (String filePath : attachments) {
                if (filePath.trim().isEmpty()) continue;
                File file = new File(filePath);
                MimeBodyPart fileBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(file);
                fileBodyPart.setDataHandler(new DataHandler((DataSource)source));
                fileBodyPart.setFileName(file.getName());
                multipart.addBodyPart((BodyPart)fileBodyPart);
            }
            message.setContent((Multipart)multipart);
            message.setSentDate(new Date());
            Transport.send((Message)message);
            LOGGER.debug((Object)("Sent email to " + recipients + ", subject: " + subject + ", attachments: " + attachments + ", body: " + text));
        }
        catch (Throwable e) {
            LOGGER.warn((Object)(this.executionContext.getToken() + ", failed to send email to " + addresses), e);
        }
    }

    protected String getAddresses(List<String> recipients) {
        if (recipients.size() == 1) {
            return " to " + recipients.get(0).toString();
        }
        return " to " + recipients.toString();
    }

    protected List<String> tokenize(String text, String tokens) {
        ArrayList<String> list = new ArrayList<String>();
        if (text == null) {
            return list;
        }
        StringTokenizer tokenizer = new StringTokenizer(text, tokens);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    @Deprecated
    protected Properties getMailServerProperties() {
        Properties properties = new Properties();
        try {
            String confFolder = ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath");
            File file = new File(confFolder, MAIL_PROPERTIES_NAME);
            FileInputStream mailServerStream = null;
            if (file.exists()) {
                mailServerStream = new FileInputStream(file);
                properties.load(mailServerStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    protected String evaluate(String expression) {
        Object result;
        block3: {
            result = expression;
            if (expression != null && !expression.trim().isEmpty()) {
                try {
                    result = this.executionContext.getVariable(expression);
                }
                catch (Exception error) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug((Object)(expression + " is not a expression. Will consider it as static text."));
                }
            }
        }
        String resultStr = null;
        resultStr = result != null ? result.toString() : expression;
        return resultStr;
    }

    protected ResourceBundle getBundle() {
        String bundleName = this.getClass().getPackage().getName() + ".mail";
        return ResourceBundle.getBundle(bundleName);
    }

    private IEmailService getEmailService() {
        if (this.emailService == null) {
            this.emailService = (IEmailService)ServiceRegistry.getDefault().lookup(IEmailService.class);
        }
        return this.emailService;
    }
}

