/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.ericsson.cms.neptune.cluster.service.IDistributedSchedulerService;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.command.ExecuteCommandCallable;
import com.tandbergtv.workflow.driver.command.buffer.IDelayedCommandService;
import com.tandbergtv.workflow.driver.command.locate.CompositeKeyMatcher;
import com.tandbergtv.workflow.driver.command.locate.RequestKeyLookup;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.AbstractCommand;
import com.tandbergtv.workflow.message.command.ICommand;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.w3c.dom.Document;

public abstract class BaseTokenCommand
extends AbstractCommand {
    private static final long serialVersionUID = 7303307342624622381L;
    private static final Logger LOGGER = Logger.getLogger(BaseTokenCommand.class);

    protected BaseTokenCommand(WorkflowMessage message) {
        super(message);
    }

    protected Token getToken() throws TokenLocatorException {
        IMessageKey key = this.message.getKey();
        if (key != null && key.toString().length() > 0) {
            return new RequestKeyLookup().locate(this.message);
        }
        return new CompositeKeyMatcher().locate(this.message);
    }

    protected abstract WorkflowMessage executeImpl(Token var1);

    public WorkflowMessage execute() {
        try {
            CustomToken token = (CustomToken)this.getToken();
            if (token == null) {
                return this.saveCommand();
            }
            if (!ProcessFinder.isOwner((WorkflowProcess)token.getProcessInstance())) {
                return this.executeCommandOnOwner(token);
            }
            this.checkStatus(token);
            if (!this.isReady(token)) {
                return this.saveCommand();
            }
            LOGGER.info((Object)("Located " + token + " for received message [" + this.message.getMessageUID() + "]"));
            this.saveRequest(this.message, token);
            return this.executeImpl((Token)token);
        }
        catch (TokenLocatorException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.logMessage(this.message);
            return this.createErrorResponse(e.getMessage());
        }
    }

    protected WorkflowMessage saveCommand() {
        IDelayedCommandService service = (IDelayedCommandService)ServiceRegistry.getDefault().lookup(IDelayedCommandService.class);
        if (service != null) {
            LOGGER.debug((Object)("Adding [" + this.message.getMessageUID() + "] to delayed buffer"));
            service.addCommand((ICommand)this);
        }
        return this.createSuccessResponse();
    }

    protected WorkflowMessage executeCommandOnOwner(CustomToken token) {
        this.getDistributedScheduler().schedule((Callable)((Object)new ExecuteCommandCallable(this.message, token)));
        return this.createSuccessResponse();
    }

    protected void checkStatus(CustomToken token) throws TokenLocatorException {
        ProcessStatus status = token.getStatus();
        if (status != ProcessStatus.BUSY && status != ProcessStatus.RUNNING && status != ProcessStatus.QUEUED) {
            throw new TokenLocatorException("Message [" + this.message.getMessageUID() + "]: found process " + token + ", status is unexpected");
        }
    }

    protected void saveRequest(WorkflowMessage message, CustomToken token) {
        Node node;
        if (message.getMessageUID().isMessageOutgoing()) {
            return;
        }
        ResourceManagement rm = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        Resource resource = rm.getResourceByToken(token.getId());
        if (resource == null && (node = token.getCurrentNode()) instanceof ResourceGroupAware) {
            String address = DeviceTypeUtil.getConnectionString((IDevice)message.getSource());
            Long id = ((ResourceGroupAware)node).getResourceGroupID();
            if (id != null) {
                LOGGER.debug((Object)(token + ", searching for resource in group " + id + " address " + address));
                resource = rm.getResourceByConnectionString(address, id.longValue());
            }
        }
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new WorkflowMessageLogEvent((Token)token, token.getNode(), true, resource, message));
    }

    private boolean isReady(CustomToken token) {
        ResourceManagement rm;
        ResourceGroup group;
        if (token.getStatus() == ProcessStatus.QUEUED && !(group = this.getResourceGroup(rm = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class), (Token)token)).isInternallyAcquired()) {
            for (ResourceGroupQueueItem item : group.getQueue()) {
                if (item.getTokenId() != token.getId()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private ResourceGroup getResourceGroup(ResourceManagement rm, Token token) {
        Node node = ((CustomToken)CustomToken.class.cast(token)).getCurrentNode();
        Long id = ((ResourceGroupAware)ResourceGroupAware.class.cast(node)).getResourceGroupID();
        if (id == null) {
            return null;
        }
        ResourceGroup group = null;
        try {
            group = rm.getResourceGroup(id.longValue());
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        return group;
    }

    protected void logMessage(WorkflowMessage message) {
        try {
            Document messageDoc = Marshaller.newMarshaller().marshal(message);
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(messageDoc), new StreamResult(writer));
            String contents = writer.toString();
            LOGGER.error((Object)("The message that failed to locate the token: " + contents));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Failed to log the incoming message[" + message.getMessageUID() + "] that failed to locate a token."));
        }
    }

    protected IDistributedSchedulerService<CustomToken> getDistributedScheduler() {
        return (IDistributedSchedulerService)ServiceRegistry.getDefault().lookup("distributed-scheduler");
    }
}

