/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.coder;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.template.ITemplateCoder;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.coder.TemplateNodeResourceBinder;
import com.tandbergtv.workflow.driver.template.coder.TemplateSerializerVersion;
import com.tandbergtv.workflow.driver.template.coder.TemplateVersionSerializer;
import com.tandbergtv.workflow.driver.template.coder.WorkflowTemplateWrapper;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.node.ProcessState;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectSerializer;

public class TemplateCoderBinaryImpl
implements ITemplateCoder {
    private static final Logger LOGGER = Logger.getLogger(TemplateCoderBinaryImpl.class);
    private static FSTConfiguration fstConf = FSTConfiguration.createDefaultConfiguration();
    private TemplateNodeResourceBinder nodeResourceBinder = TemplateNodeResourceBinder.get();

    public String encode(WorkflowTemplate template) {
        this.nodeResourceBinder.cleanError();
        Stopwatch stopwatch = Stopwatch.createStarted();
        WorkflowTemplateWrapper templateWrapper = new WorkflowTemplateWrapper(template);
        templateWrapper.setResouceGroupNameInfo(this.loadResourceGroup());
        Map<String, Node> nodes = this.nodeResourceBinder.getTemplateNodes(template);
        templateWrapper.setNodes(nodes);
        List transitions = template.getAllTransition();
        templateWrapper.setTransitions(transitions);
        this.nodeResourceBinder.removeTransitionNodeRefere(templateWrapper);
        byte[] data = fstConf.asByteArray((Object)templateWrapper);
        String content = Base64.getEncoder().encodeToString(data);
        this.nodeResourceBinder.rebindTransitionNodeRefere(templateWrapper);
        LOGGER.debug((Object)("Encode a Template object:[" + template + "] data size:" + data.length + " string size:" + content.length() + " in " + Watch.cost((Stopwatch)stopwatch)));
        return content;
    }

    protected Map<Long, String> loadResourceGroup() {
        return TemplateNodeResourceBinder.get().loadResourceGroupKeyToName();
    }

    public WorkflowTemplate decode(String content) {
        this.nodeResourceBinder.cleanError();
        Stopwatch stopwatch = Stopwatch.createStarted();
        byte[] data = Base64.getDecoder().decode(content);
        WorkflowTemplateWrapper templateWrapper = (WorkflowTemplateWrapper)fstConf.asObject(data);
        WorkflowTemplate template = templateWrapper.getTemplate();
        this.nodeResourceBinder.rebindTransitionNodeRefere(templateWrapper);
        this.nodeResourceBinder.rebuildNodeResource(template, templateWrapper.getResouceGroupNameInfo());
        this.rebindSubProcess(template);
        stopwatch.stop();
        LOGGER.debug((Object)("Decode a Template object:[" + template + "] in " + Watch.cost((Stopwatch)stopwatch)));
        return template;
    }

    private void rebindSubProcess(WorkflowTemplate template) {
        List subProcesses = template.getSubProcessRefers();
        if (subProcesses.isEmpty()) {
            return;
        }
        for (ProcessState sub : subProcesses) {
            if (sub.getSubProcessDefinition() == null) continue;
            String subProcessName = sub.getSubProcessDefinition().getName();
            WorkflowTemplate subTemplate = TemplateCoderBinaryImpl.findTemplateService().getTemplateByName(subProcessName);
            sub.setSubProcessDefinition((ProcessDefinition)subTemplate);
            if (subTemplate != null) continue;
            LOGGER.error((Object)("Cannot load sub process by " + subProcessName + " for Template[" + template.getFullName() + "]"));
        }
    }

    public List<String> getErrors() {
        return Lists.newArrayList(this.nodeResourceBinder.getErrors());
    }

    private static ITemplateService findTemplateService() {
        return (ITemplateService)ServiceRegistry.getDefault().lookup(ITemplateService.class);
    }

    static {
        fstConf.registerSerializer(TemplateSerializerVersion.class, (FSTObjectSerializer)new TemplateVersionSerializer(), true);
    }
}

