/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.coder;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ExtendedTransition;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.util.SessionUtils;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.template.coder.TransitionWrapper;
import com.tandbergtv.workflow.driver.template.coder.WorkflowTemplateWrapper;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.classic.Session;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.springframework.util.CollectionUtils;

public class TemplateNodeResourceBinder {
    private static final Logger LOGGER = Logger.getLogger(TemplateNodeResourceBinder.class);
    private Set<String> errors = Sets.newLinkedHashSet();
    private Map<String, List<TransitionWrapper>> transtionCache = new HashMap<String, List<TransitionWrapper>>();
    private Map<String, Map<String, Node>> templateNodes = new HashMap<String, Map<String, Node>>();
    private List<AbstractTaskNode> taskNodes = new ArrayList<AbstractTaskNode>();
    private static TemplateNodeResourceBinder instance = new TemplateNodeResourceBinder();
    private static Map<String, Long> resourceGroupName2Key;

    public static TemplateNodeResourceBinder get() {
        return instance;
    }

    public void cacheTransition(String templateFullname, TransitionWrapper transitionWrapper) {
        this.transtionCache.putIfAbsent(templateFullname, new ArrayList());
        List<TransitionWrapper> transtions = this.transtionCache.get(templateFullname);
        transtions.add(transitionWrapper);
    }

    public void cacheTaskNode(AbstractTaskNode taskNode) {
        this.taskNodes.add(taskNode);
    }

    public void clearTransitions(String templateName) {
        this.transtionCache.remove(templateName);
    }

    public void rebuildTransitionLink(WorkflowTemplate workflowTemplate) {
        List<TransitionWrapper> transtions = this.transtionCache.get(workflowTemplate.getFullName());
        if (transtions == null) {
            return;
        }
        for (TransitionWrapper transitionWrapper : transtions) {
            Node toNode;
            transitionWrapper.getInstance().setProcessDefinition((ProcessDefinition)workflowTemplate);
            Node fromNode = this.findBindedNode(workflowTemplate, transitionWrapper.getFromNode());
            if (fromNode != null) {
                transitionWrapper.setFrom(fromNode);
            }
            if ((toNode = this.findNodeByName(workflowTemplate, transitionWrapper.getToNode())) != null) {
                transitionWrapper.setTo(toNode);
            }
            Transition transition = transitionWrapper.getInstance();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Rebind Transition:" + transition.getClass() + "| " + transition.hashCode() + "|" + this.getNodeName(transition.getFrom()) + " >> " + this.getNodeName(transition.getTo())));
        }
    }

    private void addNoNodeError(WorkflowTemplate template, String nodeName) {
        String error = "Cannot find Node[" + nodeName + "]  in template [" + template.getFullName() + "].";
        LOGGER.error((Object)error);
        this.addError(error);
    }

    public Node findNodeByName(WorkflowTemplate template, String nodeName) {
        if (StringUtils.isBlank((String)nodeName)) {
            return null;
        }
        Node node = this.findNodeInCache(template.getFullName(), nodeName);
        if (node == null) {
            node = template.findNode(nodeName);
        }
        return node;
    }

    public Node findBindedNode(WorkflowTemplate template, String nodeName) {
        Node node = this.findNodeByName(template, nodeName);
        if (node == null) {
            this.addNoNodeError(template, nodeName);
        }
        return node;
    }

    private Node findNodeInCache(String templateName, String nodeName) {
        Map<String, Node> nodes = this.templateNodes.get(templateName);
        if (nodes != null) {
            return nodes.get(nodeName);
        }
        return null;
    }

    private String getNodeName(Node node) {
        return node == null ? null : node.getName() + "|" + node.hashCode();
    }

    public void rebuildNodeResource(WorkflowTemplate workflowTemplate, Map<Long, String> oldResourceMap) {
        Map<String, Long> newResourceNames = this.loadResourceGroupNameToKey();
        LOGGER.debug((Object)("find resource group:" + newResourceNames.size()));
        List nodes = workflowTemplate.getNodes();
        LOGGER.debug((Object)("reload resource id for  template:" + workflowTemplate.getName()));
        for (Node node : nodes) {
            ResourceGroupAware rgaNode;
            String resourceName;
            if (!(node instanceof ResourceGroupAware) || !newResourceNames.containsKey(resourceName = oldResourceMap.get((rgaNode = (ResourceGroupAware)node).getResourceGroupID()))) continue;
            Long resourceId = newResourceNames.get(resourceName);
            rgaNode.setResourceGroupID(resourceId);
            LOGGER.debug((Object)("reset the resource group id: " + resourceId + " for: " + resourceName));
        }
    }

    private Map<String, Long> loadResourceGroupNameToKey() {
        if (resourceGroupName2Key != null) {
            return resourceGroupName2Key;
        }
        HashMap<String, Long> name2Key = new HashMap<String, Long>();
        List<ResourceGroup> groups = TemplateNodeResourceBinder.loadResourceGroup();
        if (!CollectionUtils.isEmpty(groups)) {
            for (ResourceGroup group : groups) {
                name2Key.put(group.getName().toLowerCase(), group.getId());
            }
        }
        return name2Key;
    }

    public static void setResourceGroupName2Key(Map<String, Long> resourceGroupName2Key) {
        TemplateNodeResourceBinder.resourceGroupName2Key = resourceGroupName2Key;
    }

    public Map<Long, String> loadResourceGroupKeyToName() {
        List<ResourceGroup> groups = TemplateNodeResourceBinder.loadResourceGroup();
        if (CollectionUtils.isEmpty(groups)) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> name2Key = new HashMap<Long, String>();
        for (ResourceGroup group : groups) {
            name2Key.put(group.getId(), group.getName().toLowerCase());
        }
        return name2Key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ResourceGroup> loadResourceGroup() {
        Session session = HibernateUtil.getSessionFactory().openSession();
        ArrayList<ResourceGroup> groups = new ArrayList<ResourceGroup>();
        try {
            Criteria criteria = session.createCriteria(ResourceGroup.class);
            List result = criteria.list();
            if (!CollectionUtils.isEmpty((Collection)result)) {
                groups.addAll(result);
            }
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
        return groups;
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public Set<String> getErrors() {
        return this.errors;
    }

    public void cleanError() {
        this.errors.clear();
    }

    public void registerTemplateNodeInfo(String fullName, Map<String, Node> nodes) {
        this.templateNodes.put(fullName, nodes);
    }

    public Map<String, Node> initTemplateNodeInfo(WorkflowTemplate template) {
        if (!this.templateNodes.containsKey(template.getFullName())) {
            Map<String, Node> nodes = this.getTemplateNodes(template);
            this.templateNodes.put(template.getFullName(), nodes);
        }
        return this.templateNodes.get(template.getFullName());
    }

    public Map<String, Node> getTemplateNodes(WorkflowTemplate template) {
        final LinkedHashMap nodes = Maps.newLinkedHashMap();
        template.greedyBreadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                if (node != null) {
                    nodes.put(node.getName(), node);
                }
            }
        });
        return nodes;
    }

    public void verifyActionClass(Node node) {
        if (node == null || node.getAction() == null) {
            return;
        }
        if (node.getAction().getActionDelegation() != null) {
            String className = node.getAction().getActionDelegation().getClassName();
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn((Object)("Cannot find the class in current jvm classpath: " + e.getMessage()));
                this.addError("Found a unhandle action class:" + className + " in node[" + node.getName() + "]");
            }
        }
    }

    public void removeTransitionNodeRefere(WorkflowTemplateWrapper templateWrapper) {
        for (ExtendedTransition extendedTransition : templateWrapper.getTransitions()) {
            Node to;
            Node from = extendedTransition.getFrom();
            if (from != null) {
                extendedTransition.setFrom(null);
                extendedTransition.setFromNodeName(from.getName());
            }
            if ((to = extendedTransition.getTo()) == null) continue;
            extendedTransition.setTo(null);
            extendedTransition.setToNodeName(to.getName());
        }
    }

    public void rebindTransitionNodeRefere(WorkflowTemplateWrapper templateWrapper) {
        for (ExtendedTransition extendedTransition : templateWrapper.getTransitions()) {
            Node node;
            String nodeName = extendedTransition.getFromNodeName();
            if (StringUtils.isNotBlank((String)nodeName)) {
                node = templateWrapper.getNodes().get(nodeName);
                if (node != null) {
                    extendedTransition.setFrom(node);
                } else {
                    LOGGER.error((Object)("Cannot find node : " + nodeName + " in template[" + templateWrapper.getName() + "]"));
                }
            }
            if (!StringUtils.isNotBlank((String)(nodeName = extendedTransition.getToNodeName()))) continue;
            node = templateWrapper.getNodes().get(nodeName);
            if (node != null) {
                extendedTransition.setTo(node);
                continue;
            }
            LOGGER.error((Object)("Cannot find node : " + nodeName + " in template[" + templateWrapper.getName() + "]"));
        }
    }
}

