/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.coder;

import com.tandbergtv.workflow.core.entity.TemplateContentTypeEnum;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.driver.template.ITemplateCoder;
import com.tandbergtv.workflow.driver.template.ITemplateCoderFactory;
import com.tandbergtv.workflow.driver.template.coder.TemplateCoderBinaryImpl;
import com.tandbergtv.workflow.driver.template.coder.TemplateCoderJPDLImpl;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class TemplateCoderFactory
implements ITemplateCoderFactory,
Service {
    protected static final Map<TemplateContentTypeEnum, ITemplateCoder> registeredCoders = new HashMap<TemplateContentTypeEnum, ITemplateCoder>();
    private static final String DEFAULT_TEMPLATE_CODER_FACTORY = "Default Template Coder Factory";

    public ITemplateCoder create(TemplateContentTypeEnum contentType) {
        Assert.notNull((Object)registeredCoders.containsKey(contentType), (String)("Cannot find the coder by contentType:" + contentType));
        return registeredCoders.get(contentType);
    }

    public void start() {
        registeredCoders.put(TemplateContentTypeEnum.FS_BINARY, new TemplateCoderBinaryImpl());
        registeredCoders.put(TemplateContentTypeEnum.JPDL_XML, new TemplateCoderJPDLImpl());
    }

    public void stop() {
    }

    public String getServiceName() {
        return DEFAULT_TEMPLATE_CODER_FACTORY;
    }
}

