/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.neptune;

import com.google.common.base.Preconditions;
import com.tandbergtv.workflow.web.neptune.NeptuneCredentials;
import com.tandbergtv.workflow.web.neptune.ServiceLocator;
import com.tandbergtv.workflow.web.util.Credentials;
import com.tandbergtv.workflow.web.util.HttpRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class NeptuneClient<T> {
    private Route route;
    private String[] keys;
    private Principal principal;

    public NeptuneClient(Route route) {
        this(route, (String[])null);
    }

    public NeptuneClient(Route route, String ... keys) {
        this.route = route;
        this.keys = keys;
    }

    public NeptuneClient(Principal principal, Route route) {
        this(principal, route, null);
    }

    public NeptuneClient(Principal principal, Route route, String[] keys) {
        this.principal = (Principal)Preconditions.checkNotNull((Object)principal);
        this.route = route;
        this.keys = keys;
    }

    public T invoke(Class<T> clazz, String payload) throws IOException {
        Object ret = null;
        HttpRequest request = this.request();
        if ("GET".equals(this.route.method)) {
            Object obj;
            String response = request.read();
            ret = obj = new ObjectMapper(new JsonFactory()).readValue(response, clazz);
        } else {
            request.write(payload);
        }
        if (request.getStatus() >= 400) {
            throw new IOException("Request failed with response code " + request.getStatus());
        }
        return (T)ret;
    }

    public String getResponseAsString() throws IOException {
        HttpRequest request = this.request();
        String response = request.read();
        int status = request.getStatus();
        if (status >= 400) {
            throw new IOException("Request failed with response code " + status);
        }
        return response;
    }

    protected HttpRequest request() throws IOException {
        Credentials credentials = this.getCredentials();
        return new HttpRequest(this.url(credentials.isUseSSLCert())).accept("application/json").credentials(credentials).method(this.route.method);
    }

    private Credentials getCredentials() {
        Credentials credentials = new Credentials();
        String token = null;
        credentials.setUseSSLCert(this.route.isUseSSLCert());
        if (this.principal != null) {
            token = NeptuneCredentials.getOAuth2Token(this.principal);
        }
        if (token != null) {
            credentials.setOAuth2Token(token);
        } else {
            credentials.setBasicAuthCreds(NeptuneCredentials.getBasicAuthCreds());
        }
        return credentials;
    }

    private URL url(boolean isUseSSLCert) throws MalformedURLException {
        String string = ServiceLocator.baseURL(isUseSSLCert) + this.route.path;
        if (this.keys != null && this.keys.length > 0) {
            for (int i = 0; i < this.keys.length; ++i) {
                string = string + this.keys[i];
            }
        }
        return new URL(string);
    }

    public static final class Route {
        String path;
        String method;
        boolean useSSLCert = false;
        public static final Route SETTINGS = new Route("/cms/services/settings/", true);
        public static final Route SETTINGS_SAVE = new Route("/cms/services/settings/", "PUT", true);
        public static final Route USER_DETAILS = new Route("/cms/services/users/getUsers", true);
        public static final Route USER_SELF = new Route("/cms/services/users/self");
        public static final Route LICENSE_DETAILS = new Route("/cms/services/licensing/", true);
        public static final Route LICENSE_PROPERTY = new Route("/cms/services/licensing/getProperty?key=", true);
        public static final Route PARTNERS = new Route("/services/partners");
        public static final Route TITLE_USERS = new Route("/services/titles/", false);
        public static final Route TITLE_SERVICE = new Route("/services/titles/", "PUT", true);

        Route(String path) {
            this(path, "GET");
        }

        Route(String path, boolean useSSLCert) {
            this(path, "GET");
            this.useSSLCert = useSSLCert;
        }

        Route(String path, String method) {
            this.path = path;
            this.method = method;
        }

        Route(String path, String method, boolean useSSLCert) {
            this.path = path;
            this.method = method;
            this.useSSLCert = useSSLCert;
        }

        boolean isUseSSLCert() {
            return this.useSSLCert;
        }
    }
}

