/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.comm.internal;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.TCPDevice;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;

public class DeviceFactory {
    private static final Logger LOGGER = Logger.getLogger(DeviceFactory.class);

    public static DeviceFactory newInstance() {
        return new DeviceFactory();
    }

    public IDevice createDevice(String url) throws MalformedURLException {
        return this.createDevice(url, null);
    }

    public IDevice createDevice(String url, String name) throws MalformedURLException {
        LOGGER.debug((Object)("Creating device for url " + url));
        if (url.startsWith("tcp://") || url.startsWith("net.tcp://")) {
            String[] components = url.split("tcp://");
            String[] hostAndPort = components[1].split(":");
            String ip = hostAndPort[0];
            int port = 0;
            if (hostAndPort.length == 2) {
                port = Integer.parseInt(hostAndPort[1]);
            }
            return new TCPDevice(ip, port, name);
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return new HTTPDevice(url, name);
        }
        throw new MalformedURLException("URL " + url + " is not supported");
    }
}

