/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.MarshalException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Unmarshaller {
    private static final Logger LOGGER = Logger.getLogger(Unmarshaller.class);

    public static WorkflowMessage unmarshal(Document document) throws MarshalException {
        WorkflowMessage message = null;
        try {
            Element root = document.getDocumentElement();
            String uid = root.getAttribute("UID");
            String type = root.getAttribute("Type");
            String key = root.getAttribute("RequestKey");
            String origin = root.getAttribute("MessageOrigin");
            message = Unmarshaller.createWorkflowMessage(uid, type, key, origin);
            Unmarshaller.unmarshalCommand(document, message);
            Unmarshaller.unmarshalProperties(document, message);
            Unmarshaller.unmarshal(document, message);
        }
        catch (Exception e) {
            throw new MarshalException("Failed to unmarshal the document", e);
        }
        return message;
    }

    protected static void unmarshal(Document document, WorkflowMessage message) {
        NodeList nodes = document.getElementsByTagName("ParameterList");
        if (nodes.getLength() == 0) {
            return;
        }
        NodeList parameters = nodes.item(0).getChildNodes();
        WorkflowPayload payload = message.getPayload();
        int i = 0;
        while (i < parameters.getLength()) {
            if (parameters.item(i) instanceof Element) {
                Element parameter = (Element)parameters.item(i);
                String type = parameter.getAttribute("DataType");
                if ("List".equals(type)) {
                    Unmarshaller.parseList(parameter, payload);
                } else {
                    Unmarshaller.parseParameter(parameter, payload);
                }
            }
            ++i;
        }
    }

    protected static void parseParameter(Element parameter, WorkflowPayload payload) {
        String name = parameter.getAttribute("Name");
        Element element = (Element)parameter.getElementsByTagName("Value").item(0);
        String value = element.getTextContent();
        payload.putValue(name, (Object)value);
    }

    protected static void parseList(Element e, WorkflowPayload payload) {
        ArrayList<String> list = new ArrayList<String>();
        NodeList nodes = e.getElementsByTagName("Parameter");
        int i = 0;
        while (i < nodes.getLength()) {
            Element parameter = (Element)nodes.item(i);
            Element element = (Element)parameter.getElementsByTagName("Value").item(0);
            String value = element.getTextContent();
            list.add(value);
            ++i;
        }
        payload.putValue(e.getAttribute("Name"), list);
    }

    private static void unmarshalProperties(Document document, WorkflowMessage message) {
        NodeList nodes = document.getElementsByTagName("Source");
        Element e = (Element)nodes.item(0);
        if (e != null && e.hasChildNodes()) {
            nodes = e.getChildNodes();
            String name = e.getAttribute("Name");
            LOGGER.debug((Object)("Source name = " + name));
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i) instanceof Element) {
                    Element deviceElement = (Element)nodes.item(i);
                    LOGGER.debug((Object)("Device Element = " + deviceElement.getNodeName()));
                    ISource source = (ISource)Unmarshaller.createDevice(name, deviceElement);
                    message.setSource(source);
                    break;
                }
                ++i;
            }
        }
        if ((e = (Element)(nodes = document.getElementsByTagName("ResponseDestination")).item(0)) != null && e.hasChildNodes()) {
            nodes = e.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i) instanceof Element) {
                    Element deviceElement = (Element)nodes.item(i);
                    IDestination responseDestination = (IDestination)Unmarshaller.createDevice(null, deviceElement);
                    message.setResponseDestination(responseDestination);
                    break;
                }
                ++i;
            }
        }
    }

    private static IDevice createDevice(String name, Element deviceElement) {
        ISource device = null;
        if (deviceElement.getTagName() == "URL") {
            String url = deviceElement.getTextContent();
            device = new HTTPDevice(url, name);
        } else if (deviceElement.getTagName() == "Host") {
            String ip = deviceElement.getAttributes().getNamedItem("IP").getTextContent();
            String portString = deviceElement.getAttributes().getNamedItem("Port").getTextContent();
            int port = portString == null ? 0 : Integer.parseInt(portString);
            device = new TCPDevice(ip, port);
        }
        return device;
    }

    private static WorkflowMessage createWorkflowMessage(String uid, String type, String key, String origin) {
        MessageUIDImpl messageUID = new MessageUIDImpl(uid);
        MessageKeyImpl messageKey = new MessageKeyImpl(key);
        WorkflowMessage.MessageType messageType = WorkflowMessage.MessageType.valueOf(type);
        MessageKeyImpl originKey = null;
        if (origin != null) {
            originKey = new MessageKeyImpl(origin);
        }
        return new WorkflowMessage(messageUID, messageKey, originKey, messageType);
    }

    private static void unmarshalCommand(Document document, WorkflowMessage message) throws Exception {
        NodeList nodes = document.getElementsByTagName("Command");
        if (nodes.getLength() == 0) {
            return;
        }
        Element e = (Element)nodes.item(0);
        WPCLCommand command = new WPCLCommand(e.getAttribute("Name"));
        int i = 0;
        while (i < e.getChildNodes().getLength()) {
            Node node = e.getChildNodes().item(i);
            if (node instanceof Element) {
                Element child = (Element)node;
                String name = child.getAttribute("Name");
                String value = child.getAttribute("Value");
                command.addParameter(name, value);
            }
            ++i;
        }
        message.setCommand(command);
    }
}

