/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WPCLConverter {
    private static final ThreadLocal<Transformer> TRANSFORMER = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerException e) {
                throw new Error();
            }
        }
    };
    private static final ThreadLocal<DocumentBuilder> BUILDER = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                return factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new Error();
            }
        }
    };

    public WorkflowMessage convert(IMessage message) throws Exception {
        return Unmarshaller.unmarshal(this.getDocument(message.getPayload().getContent()));
    }

    public IMessage convert(WorkflowMessage message) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(message);
        Transformer transformer = this.getTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(writer));
        return new MessageImpl(new StringPayload(writer.getBuffer().toString()));
    }

    private Document getDocument(String content) throws Exception {
        InputSource inputSource = new InputSource(new StringReader(content));
        return this.getDocumentBuilder().parse(inputSource);
    }

    private Transformer getTransformer() {
        Transformer transformer = TRANSFORMER.get();
        transformer.reset();
        return transformer;
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder = BUILDER.get();
        builder.reset();
        return builder;
    }
}

