/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class AlarmNotificationService
implements IAlarmNotificationService {
    private Set<IAlarmNotificationProvider> providers = new CopyOnWriteArraySet<IAlarmNotificationProvider>();

    @Override
    public List<AlarmNotification> getAlarms(long timestamp) {
        Calendar dateCutoff = Calendar.getInstance();
        dateCutoff.setTimeInMillis(timestamp);
        ArrayList<AlarmNotification> alarms = new ArrayList<AlarmNotification>();
        for (IAlarmNotificationProvider provider : this.providers) {
            alarms.addAll(provider.getAlarms(dateCutoff));
        }
        return alarms;
    }

    @Override
    public void addProvider(IAlarmNotificationProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public void removeProvider(IAlarmNotificationProvider provider) {
        this.providers.remove(provider);
    }

    public void start() {
    }

    public void stop() {
        this.providers.clear();
    }

    public String getServiceName() {
        return "alarm-notifications";
    }
}

