/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.monitor.core.Metric;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileRecorderProperties {
    private static final String FILE_FORMAT = "yyyyMMdd";

    public static File directoryFor(File root, Metric metric) {
        boolean created;
        File dir = new File(root, metric.getType());
        if (!dir.exists() && !(created = dir.mkdirs())) {
            throw new RuntimeException("Failed to create directory" + dir);
        }
        return dir;
    }

    public static File getFile(File dir, Metric metric) {
        SimpleDateFormat formatter = new SimpleDateFormat(FILE_FORMAT);
        String time = formatter.format(new Date());
        String name = String.format("%s_%s", metric.getDomain(), time);
        return new File(dir, name);
    }

    public static File getFile(File dir, String extension, Metric metric) {
        SimpleDateFormat formatter = new SimpleDateFormat(FILE_FORMAT);
        String time = formatter.format(new Date());
        String name = String.format("%s_%s", metric.getDomain(), time);
        return new File(dir, name + "." + extension);
    }

    public static File getPNGFile(File dir, Metric metric) {
        return FileRecorderProperties.getFile(dir, "png", metric);
    }
}

