/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.internal.JMXMetric;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class JMXObserver
implements IObserver {
    private ObjectName name;
    private String attribute;
    private MBeanServerConnection connection;
    private static final Logger LOGGER = Logger.getLogger(JMXObserver.class);

    public JMXObserver(MBeanServerConnection connection, ObjectName name, String attribute) {
        this.connection = connection;
        this.name = name;
        this.attribute = attribute;
    }

    @Override
    public Set<Metric> getMetricNames() {
        HashSet<Metric> metrics = new HashSet<Metric>();
        try {
            for (ObjectName on : this.connection.queryNames(this.name, null)) {
                metrics.add(JMXMetric.fromObjectName(on, this.attribute));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)this.name.getCanonicalName(), (Throwable)e);
        }
        return metrics;
    }

    @Override
    public List<Metric> getMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        try {
            for (ObjectName on : this.connection.queryNames(this.name, null)) {
                Metric metric = JMXMetric.fromObjectName(on, this.attribute);
                metric.setValue(this.getValue(on));
                metrics.add(metric);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)(this.name.getCanonicalName() + " attribute " + this.attribute), (Throwable)e);
        }
        return metrics;
    }

    private Object getValue(ObjectName name) throws JMException, IOException {
        return this.connection.getAttribute(name, this.attribute);
    }
}

