/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.entity;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcessNote;
import com.tandbergtv.workflow.core.entity.CustomTokenDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class WorkflowProcessDTO
implements Serializable {
    private static final long serialVersionUID = -2932237261916958322L;
    long id;
    long parentId;
    long rootTokenId;
    long templateId;
    ProcessPriority priority;
    String processNotes;
    boolean isActive;
    Date createDate;
    Date updateDate;
    String createId;
    private Set<WorkflowProcessDTO> subProcesses = new HashSet<WorkflowProcessDTO>();
    private CustomTokenDTO rootToken;
    private Set<CustomTokenDTO> childrenTokens = new HashSet<CustomTokenDTO>();

    public long getId() {
        return this.id;
    }

    public WorkflowProcessDTO setId(long id) {
        this.id = id;
        return this;
    }

    public long getParentId() {
        return this.parentId;
    }

    public WorkflowProcessDTO setParentId(long parentId) {
        this.parentId = parentId;
        return this;
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public WorkflowProcessDTO setTemplateId(long templateId) {
        this.templateId = templateId;
        return this;
    }

    public CustomTokenDTO getRootToken() {
        return this.rootToken;
    }

    public WorkflowProcessDTO setRootToken(CustomTokenDTO rootToken) {
        this.rootToken = rootToken;
        return this;
    }

    public WorkflowProcessDTO setSubProcesses(List<WorkflowProcessDTO> subProcesses) {
        this.subProcesses.clear();
        this.subProcesses.addAll(subProcesses);
        return this;
    }

    public List<WorkflowProcessDTO> getSubProcesses() {
        return new ArrayList<WorkflowProcessDTO>(this.subProcesses);
    }

    public long getRootTokenId() {
        return this.rootTokenId;
    }

    public WorkflowProcessDTO setRootTokenId(long rootTokenId) {
        this.rootTokenId = rootTokenId;
        return this;
    }

    public ProcessPriority getPriority() {
        return this.priority;
    }

    public WorkflowProcessDTO setPriority(ProcessPriority priority) {
        this.priority = priority;
        return this;
    }

    public String getProcessNotes() {
        return this.processNotes;
    }

    public WorkflowProcessDTO setProcessNotes(String processNotes) {
        this.processNotes = processNotes;
        return this;
    }

    public WorkflowProcessDTO setProcessNotes(WorkflowProcessNote note) {
        if (note == null || note.getNotes().isEmpty()) {
            this.processNotes = null;
            return this;
        }
        this.setProcessNotes(note.getJsonFormattedNotes());
        return this;
    }

    public String getCreateId() {
        return this.createId;
    }

    public WorkflowProcessDTO setCreateId(String createId) {
        this.createId = createId;
        return this;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public WorkflowProcessDTO setActive(boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public WorkflowProcessDTO setCreateDate(Date createDate) {
        this.createDate = createDate;
        return this;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public WorkflowProcessDTO setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
        return this;
    }

    public List<CustomTokenDTO> getChildrenTokens() {
        return new ArrayList<CustomTokenDTO>(this.childrenTokens);
    }

    public WorkflowProcessDTO addChildrenToken(CustomTokenDTO token) {
        this.childrenTokens.add(token);
        return this;
    }

    public WorkflowProcessDTO setChildrenTokens(List<CustomTokenDTO> children) {
        this.childrenTokens.clear();
        this.childrenTokens.addAll(children);
        return this;
    }

    public boolean isSubprocess() {
        return this.getParentId() > 0L;
    }

    public String toString() {
        String isActiveStr = this.isActive ? "1" : "0";
        return "WorkflowProcessDTO [id=" + this.id + ", rootTokenId=" + this.rootTokenId + ", parentId=" + this.parentId + ", templateId=" + this.templateId + ", priority=" + this.getPriorityName() + ", processNotes=" + this.processNotes + ", isActive=" + isActiveStr + "]";
    }

    private String getPriorityName() {
        return this.priority == null ? null : this.priority.name();
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return Objects.equals(this.hashCode(), obj.hashCode());
    }
}

