/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;

public class JsonObjectMapper {
    private static final Logger logger = Logger.getLogger(JsonObjectMapper.class);

    public static <K, V> String toJsonString(Map<K, V> variables) {
        String jsonString = null;
        try {
            jsonString = new ObjectMapper().writeValueAsString(variables);
        }
        catch (IOException e) {
            logger.warn((Object)("errors occur when mapping HashMap to json String: " + e));
        }
        return jsonString;
    }

    public static <V> String toJsonString(List<V> variables) {
        String jsonString = null;
        try {
            jsonString = new ObjectMapper().writeValueAsString(variables);
        }
        catch (IOException e) {
            logger.warn((Object)("errors occur when mapping HashMap to json String: " + e));
        }
        return jsonString;
    }

    public static Map<String, Object> toMap(String jsonString) {
        Map<String, Object> vars = new LinkedHashMap<String, Object>();
        if (StringUtils.isBlank((String)jsonString)) {
            return vars;
        }
        try {
            vars = (Map)new ObjectMapper().readValue(jsonString, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
        }
        catch (IOException e) {
            logger.warn((Object)("errors occur when mapping json String to HashMap: " + e.getMessage()));
        }
        return vars;
    }

    public static List<Map<String, Serializable>> toList(String jsonString) {
        if (StringUtils.isBlank((String)jsonString)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Serializable>> vars = new ArrayList<Map<String, Serializable>>();
        try {
            List temps = (List)new ObjectMapper().readValue(jsonString, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            for (Map map : temps) {
                LinkedHashMap newItem = new LinkedHashMap();
                for (Map.Entry item : map.entrySet()) {
                    newItem.put(item.getKey(), (Serializable)item.getValue());
                }
                vars.add(newItem);
            }
        }
        catch (IOException e) {
            logger.warn((Object)("errors occur when mapping json String to HashMap: " + e.getMessage()));
        }
        return vars;
    }

    public static <T> T toList(String jsonContent, Class<?> target) {
        if (StringUtils.isBlank((String)jsonContent)) {
            return (T)Collections.emptyList();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(List.class, Class.forName(target.getName()));
            return (T)objectMapper.readValue(jsonContent, (JavaType)collectionType);
        }
        catch (IOException | ClassNotFoundException e) {
            logger.warn((Object)("errors occur when mapping json String to List: " + e.getMessage()));
            return (T)Collections.emptyList();
        }
    }
}

