/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.TemplateContentTypeEnum;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.IArchivalService;
import com.tandbergtv.workflow.driver.template.ITemplateCache;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import com.tandbergtv.workflow.driver.template.TemplateService;
import com.tandbergtv.workflow.driver.template.event.TemplateEvent;
import com.tandbergtv.workflow.driver.template.event.TemplateEvents;
import com.tandbergtv.workflow.driver.template.internal.ArchivalService;
import com.tandbergtv.workflow.driver.template.internal.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.node.ProcessState;

public class TemplateLoaderService
implements ITemplateLoaderService {
    private static final String SERVICE_NAME = "Template Loader Service";
    private ITemplateService templateService;
    private IArchivalService archiver;
    private ISchedulerService<Void> scheduler;
    private int max;
    private Collection<UnparsedTemplate> list;
    private static final Logger LOGGER = Logger.getLogger(TemplateLoaderService.class);

    public TemplateLoaderService(int maxTemplateAmount, SessionFactory factory) {
        this.max = maxTemplateAmount;
        this.list = Collections.synchronizedList(new ArrayList());
        this.scheduler = this.getScheduler();
        this.archiver = this.getArchiver();
        this.templateService = (ITemplateService)ServiceRegistry.getDefault().lookup(TemplateService.class);
    }

    public ISchedulerService<Void> getScheduler() {
        if (this.scheduler == null) {
            return new Scheduler("template", 1, 1);
        }
        return this.scheduler;
    }

    public void setScheduler(ISchedulerService<Void> scheduler) {
        this.scheduler = scheduler;
    }

    public IArchivalService getArchiver() {
        if (this.archiver == null) {
            this.archiver = new ArchivalService(this.scheduler);
        }
        return this.archiver;
    }

    public void setArchiver(IArchivalService archiver) {
        this.archiver = archiver;
    }

    public ITemplateService getTemplateService() {
        return this.templateService;
    }

    public void setTemplateService(ITemplateService templateService) {
        this.templateService = templateService;
    }

    public Collection<UnparsedTemplate> getList() {
        return this.list;
    }

    @Override
    public void runCompiler(File file, ITemplateReader reader) {
        this.list.add(new UnparsedTemplate(file, reader));
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.scheduler.schedule((Callable)new CacheLoader());
        this.scheduler.schedule((Runnable)new CompilerTask(), 0L, 10000L);
    }

    public void stop() {
        this.archiver.stop();
        this.scheduler.stop();
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
    }

    protected void save(File file, WorkflowTemplate template, String xmlContent) throws DriverException {
        this.checkVersion(template);
        this.checkLicense(template);
        Files.unzipArchive(template, file);
        this.templateService.create(template, xmlContent, TemplateContentTypeEnum.JPDL_XML);
        this.archiver.run(template);
        if (!Files.success(file)) {
            LOGGER.warn((Object)("Failed to move Template file " + file.getAbsolutePath()));
        }
    }

    private Collection<UnparsedTemplate> firstPass(Collection<UnparsedTemplate> files) {
        ArrayList<UnparsedTemplate> pending = new ArrayList<UnparsedTemplate>();
        for (UnparsedTemplate unparsed : files) {
            File file = unparsed.file;
            ITemplateReader reader = unparsed.reader;
            WorkflowTemplate template = null;
            String xmlContent = null;
            try {
                template = reader.read();
                xmlContent = reader.getXmlContent();
                ReferenceChecker visitor = new ReferenceChecker();
                template.greedyBreadthFirstTraversal((NodeVisitor)visitor);
                if (visitor.hasReferences) {
                    pending.add(unparsed);
                    continue;
                }
                this.fireEvent(file, template, TemplateEvents.COMPILED);
                this.save(file, template, xmlContent);
            }
            catch (TemplateReaderException e) {
                if (e.hasUnresolvedReferences()) {
                    pending.add(unparsed);
                    continue;
                }
                this.die(file, template, (Exception)((Object)e));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to ingest template " + file.getAbsolutePath()), (Throwable)e);
                Files.reject(file);
            }
        }
        return pending;
    }

    private void secondPass(Collection<UnparsedTemplate> files) {
        for (UnparsedTemplate unparsed : files) {
            File file = unparsed.file;
            ITemplateReader reader = unparsed.reader;
            WorkflowTemplate template = null;
            String xmlContent = null;
            try {
                template = reader.read();
                xmlContent = reader.getXmlContent();
                this.fireEvent(file, template, TemplateEvents.COMPILED);
                LOGGER.debug((Object)template);
                this.save(file, template, xmlContent);
            }
            catch (TemplateReaderException e) {
                this.die(file, template, (Exception)((Object)e));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to ingest template " + file.getAbsolutePath()), (Throwable)e);
                Files.reject(file);
            }
        }
    }

    private ITemplateCache getCache() {
        return this.templateService.getCache();
    }

    private void checkLicense(WorkflowTemplate template) throws DriverException {
        int count = this.getLicenseCount();
        for (WorkflowTemplate t : this.templateService.getLatestTemplates()) {
            if (!t.getName().equals(template.getName())) continue;
            return;
        }
        if (this.templateService.getLatestTemplates().size() >= count) {
            throw new DriverException("License unavailable for template " + template.getFullName() + ", limit = " + count);
        }
    }

    private void checkVersion(WorkflowTemplate template) throws DriverException {
        WorkflowTemplate latest = this.templateService.getTemplateByName(template.getName());
        if (latest != null && latest.getVersion() >= template.getVersion()) {
            throw new DriverException("Template " + template + " - version must exceed " + latest.getVersion());
        }
        if (this.templateService.isDuplicatedVersion(template.getName(), template.getVersion())) {
            throw new DriverException("Template " + template + " - version  " + template.getVersion() + " has been existed in system");
        }
    }

    private void die(File file, WorkflowTemplate template, Exception e) {
        LOGGER.error((Object)("Failed to ingest template " + file.getAbsolutePath()), (Throwable)e);
        this.fireEvent(file, template, TemplateEvents.COMPILE_ERROR);
        Files.reject(file);
    }

    private void fireEvent(Object source, WorkflowTemplate template, TemplateEvents type) {
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new TemplateEvent(source, template, type));
    }

    private int getLicenseCount() {
        return this.max;
    }

    private final class UnparsedTemplate {
        File file;
        ITemplateReader reader;

        UnparsedTemplate(File file, ITemplateReader reader) {
            this.file = file;
            this.reader = reader;
        }
    }

    private final class ReferenceChecker
    implements NodeVisitor {
        boolean hasReferences = false;

        private ReferenceChecker() {
        }

        public void visit(Node node) {
            if (node instanceof ProcessState) {
                this.hasReferences = true;
            }
        }
    }

    private final class CacheLoader
    implements Callable<Void> {
        private CacheLoader() {
        }

        @Override
        public Void call() throws Exception {
            try {
                TemplateLoaderService.this.templateService.loadActiveTemplates();
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)TemplateLoaderService.this, ServiceEvents.STARTED));
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Failed to load templates", e);
            }
            TemplateLoaderService.this.archiver.start();
            return null;
        }
    }

    private final class CompilerTask
    implements Runnable {
        private CompilerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TemplateLoaderService.this.list.isEmpty()) {
                return;
            }
            LOGGER.debug((Object)("Count is " + TemplateLoaderService.this.list.size()));
            ArrayList copy = null;
            Collection collection = TemplateLoaderService.this.list;
            synchronized (collection) {
                copy = new ArrayList(TemplateLoaderService.this.list);
                TemplateLoaderService.this.list.clear();
            }
            if (copy.isEmpty()) {
                return;
            }
            TemplateLoaderService.this.secondPass(TemplateLoaderService.this.firstPass(copy));
        }
    }
}

