/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.scheduler.def.CreateTimerAction;

public class NodeTimeoutGetter
implements NodeVisitor {
    private static final Logger logger = Logger.getLogger(NodeTimeoutGetter.class);
    Map<String, Object> timeouts;

    NodeTimeoutGetter(Map<String, Object> dtoNodeTimeouts) {
        this.timeouts = dtoNodeTimeouts;
    }

    public void visit(Node node) {
        Event event = null;
        if (node instanceof AbstractTaskNode) {
            event = node.getEvent("node-enter");
        } else if (node instanceof SuperState) {
            event = node.getEvent("superstate-enter");
        }
        if (event == null || !event.hasActions()) {
            return;
        }
        for (Object action : event.getActions()) {
            if (!(action instanceof CreateTimerAction)) continue;
            CreateTimerAction timer = (CreateTimerAction)CreateTimerAction.class.cast(action);
            String dueDate = timer.getDueDate();
            this.timeouts.put(node.getName(), dueDate);
            logger.debug((Object)(node.getName() + " timeout " + dueDate));
        }
    }
}

