/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.token;

import com.ericsson.cms.neptune.cluster.service.IDistributedSchedulerService;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;

public abstract class AbstractTokenHandler
implements ActionHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractTokenHandler.class);
    private static final long serialVersionUID = 5114384755308608790L;
    private IDistributedSchedulerService<CustomToken> recoverableDistributedScheduler;
    private IDistributedSchedulerService<CustomToken> distributedScheduler;

    protected AbstractTokenHandler() {
    }

    protected Future<CustomToken> call(TokenCallable callable) {
        return this.getDistributedScheduler().schedule((Callable)((Object)callable));
    }

    protected Future<CustomToken> callAndForget(TokenCallable callable) {
        return this.getOneShotDistributedScheduler().schedule((Callable)((Object)callable));
    }

    protected IDistributedSchedulerService<CustomToken> getDistributedScheduler() {
        if (this.recoverableDistributedScheduler == null) {
            this.recoverableDistributedScheduler = (IDistributedSchedulerService)ServiceRegistry.getDefault().lookup("distributed-scheduler");
        }
        return this.recoverableDistributedScheduler;
    }

    protected IDistributedSchedulerService<CustomToken> getOneShotDistributedScheduler() {
        if (this.distributedScheduler == null) {
            this.distributedScheduler = (IDistributedSchedulerService)ServiceRegistry.getDefault().lookup("one-shot-distributed-scheduler");
        }
        return this.distributedScheduler;
    }

    protected ISchedulerService<CustomToken> getScheduler() {
        return this.getService().getScheduler();
    }

    protected IProcessManagerService getService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    protected CustomToken getSuperProcessToken(CustomToken token) {
        CustomToken superProcessToken = token.getProcessInstance().getSuperProcessToken();
        if (superProcessToken == null) {
            return null;
        }
        WorkflowProcessCache cache = (WorkflowProcessCache)ServiceRegistry.getDefault().lookup("Process Cache");
        WorkflowProcess process = (WorkflowProcess)cache.get(Long.valueOf(superProcessToken.getProcessInstance().getId()));
        if (process == null) {
            LOGGER.info((Object)(token + ", parent " + superProcessToken + " has already completed"));
            return null;
        }
        if ((superProcessToken = process.findToken(superProcessToken.getId())) != null && superProcessToken.getSubProcessInstance() == null) {
            LOGGER.warn((Object)(token + ", parent " + token.getProcessInstance().getSuperProcessToken() + " forgot about me :("));
            return null;
        }
        return superProcessToken;
    }
}

