/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.driver.HazelcastNodeIdFinder;
import com.tandbergtv.workflow.driver.internal.IEntityIdGenerator;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;

public class IdGeneratorTimerImpl
implements IEntityIdGenerator {
    static final int PREDEFINED_TIMESTAMP_LENGTH = 13;

    @Override
    public synchronized String newTemplateId() {
        return IdGeneratorTimerImpl.generateUniqueId("01");
    }

    @Override
    public synchronized String newProcessId() {
        return IdGeneratorTimerImpl.generateUniqueId("02");
    }

    private static String generateUniqueId(String idType) {
        String nodeId = StringUtils.leftPad((String)HazelcastNodeIdFinder.getNodeId(), (int)3, (char)'0');
        long wfsUniqueId = System.currentTimeMillis();
        return wfsUniqueId + idType + nodeId;
    }

    @Override
    public String tidyId(long id) {
        return StringUtils.leftPad((String)String.valueOf(id), (int)18, (char)'0');
    }

    @Override
    public String tidyId(String id) {
        return StringUtils.leftPad((String)id, (int)18, (char)'0');
    }

    @Override
    public Boolean isValid(String id) {
        Boolean isTimerId = false;
        if (StringUtils.isBlank((String)id)) {
            return isTimerId;
        }
        Long timeStamp = Long.valueOf(id.substring(13));
        Calendar timeFromId = Calendar.getInstance();
        timeFromId.setTimeInMillis(timeStamp);
        Calendar javaTime = Calendar.getInstance();
        javaTime.set(1970, 0, 1);
        if (id.length() == 18 && timeFromId.after(javaTime)) {
            isTimerId = true;
        }
        return isTimerId;
    }
}

