/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class EndTaskInstance
extends TokenCallable {
    private static final long serialVersionUID = -6045591719419204158L;
    private Map<String, Object> variables;
    private long taskId;

    public EndTaskInstance(CustomToken token, TaskInstance ti, Map<String, Object> variables) {
        super(token);
        this.taskId = ti.getId();
        this.variables = variables;
    }

    @Override
    protected Callable<CustomToken> innerCallable(final CustomToken token) {
        return new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    TaskInstance ti = EndTaskInstance.this.getTaskInstance(token);
                    EndTaskInstance.this.setVariables(ti);
                    ti.end();
                }
                catch (Throwable t) {
                    Logger.getLogger(EndTaskInstance.class).error((Object)token, t);
                }
                return token;
            }
        };
    }

    protected void setVariables(TaskInstance ti) {
        for (String key : this.variables.keySet()) {
            Object value = this.variables.get(key);
            if (value == null) continue;
            ti.setVariable(key, value);
        }
    }

    protected TaskInstance getTaskInstance(CustomToken token) {
        WorkflowProcess process = token.getProcessInstance();
        Collection tasks = process.getTaskMgmtInstance().getTaskInstances();
        for (Object o : tasks) {
            TaskInstance ti = (TaskInstance)o;
            if (ti.getId() != this.taskId || ti.getToken().getId() != this.tokenId || ti.hasEnded()) continue;
            return ti;
        }
        return null;
    }
}

