/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.IDistributedSchedulerService;
import com.tandbergtv.workflow.driver.internal.callable.AlarmNotificationCallable;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class GenericAlarmNotificationProvider
implements IAlarmNotificationProvider {
    private static final Logger LOGGER = Logger.getLogger(GenericAlarmNotificationProvider.class);
    public static final String ALARM_RECOVERY_URL = "/workflow/process/";
    public static final String CHILD_PROCESS_ERROR_MSG_PREFIX = "alarms.childProcess.error.prefix";
    private IDistributedSchedulerService<Set<AlarmNotification>> distributedSchedulerService;

    public final Set<AlarmNotification> getAlarms(Calendar dateCutoff) {
        HashSet set = new HashSet();
        try {
            Collection alarms = (Collection)this.getDistributedSchedulerService().scheduleMulti((Callable)((Object)new AlarmNotificationCallable(dateCutoff))).get();
            set = Sets.newHashSet((Iterable)Iterables.concat((Iterable)alarms));
            LOGGER.debug((Object)("Found " + set.size() + " process alarms"));
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn((Object)"Exception thrown while getting alarms from all nodes", (Throwable)e);
        }
        return set;
    }

    private IDistributedSchedulerService<Set<AlarmNotification>> getDistributedSchedulerService() {
        if (this.distributedSchedulerService == null) {
            this.distributedSchedulerService = (IDistributedSchedulerService)ServiceRegistry.getDefault().lookup("distributed-scheduler");
        }
        return this.distributedSchedulerService;
    }
}

