/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class UsageCalculator
implements Runnable {
    private final int limit;
    private final Collection<String> keys;
    private final Properties properties;
    private static Logger LOGGER = Logger.getLogger(UsageCalculator.class);

    public UsageCalculator(int threshold, Collection<String> keys, Properties properties) {
        this.limit = threshold == 0 ? Integer.MAX_VALUE : threshold;
        this.keys = keys;
        this.properties = properties;
    }

    @Override
    public void run() {
        Set<Long> ids = this.getTemplates();
        if (ids.isEmpty()) {
            return;
        }
        int total = this.count(this.buildCriteria(ids, this.getCutoff()));
        boolean flag = total > this.limit;
        this.properties.setProperty("create.limit.exceeded", String.valueOf(flag));
        LOGGER.debug((Object)("Limit " + this.limit + " actual " + total));
    }

    private SearchCriteria buildCriteria(Set<Long> ids, Date date) {
        SearchCriteria criteria = new SearchCriteria();
        ListParameter templates = new ListParameter("processDefinition.id", SearchType.NUMERIC);
        templates.addValues(ids.toArray());
        criteria.addParameter((SearchParameterBase)templates);
        criteria.addParameter((SearchParameterBase)new ValueParameter("status", SearchType.PROCESSSTATUS, (Object)ProcessStatus.COMPLETED.name()));
        criteria.addParameter((SearchParameterBase)new RangeParameter("end", SearchType.DATE, new SimpleDateFormat("yyyy-MM-dd").format(date)));
        criteria.addParameter((SearchParameterBase)new ValueParameter("all"));
        criteria.setRecordsCount(1);
        return criteria;
    }

    private Set<Long> getTemplates() {
        ITemplateLoaderService service = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        HashSet<Long> templates = new HashSet<Long>();
        for (String selector : this.keys) {
            try {
                WorkflowTemplate template = service.getTemplateBySelectorKey(selector);
                templates.add(template.getId());
                LOGGER.debug((Object)("Template " + template.getFullName()));
            }
            catch (Exception e) {}
        }
        return templates;
    }

    private int count(SearchCriteria criteria) {
        return ((IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class)).expressCount(criteria);
    }

    private Date getCutoff() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

