/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessAlarmMatcher;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmSeverity;
import com.tandbergtv.workflow.monitor.core.alarm.Intent;
import com.tandbergtv.workflow.monitor.core.alarm.IntentAction;
import com.tandbergtv.workflow.monitor.core.alarm.IntentOperation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class ManualTaskAlarmNotification
implements ProcessAlarmMatcher {
    private static final Logger LOGGER = Logger.getLogger(ManualTaskAlarmNotification.class);
    private AtomicInteger counter = new AtomicInteger(0);
    public static final String MANUAL_TASK_PORTAL_URL = "/portal/#Workflow.User%20Tasks.Perform?id=";
    public static final String VAR_TITLE_ID = "titleId";
    public static final String VAR_TITLE_BRIEF = "titleBrief";
    public static final String VAR_ANNOTATIONS = "annotations";

    @Override
    public boolean match(CustomToken token, Calendar dateCutoff) {
        return token.getStatus() == ProcessStatus.BUSY && token.getNode() instanceof ManualTaskNode && token.getNodeEnter() != null && dateCutoff.getTime().before(token.getNodeEnter());
    }

    public List<AlarmNotification> buildAlarmsForProcess(WorkflowProcess process) {
        ArrayList<AlarmNotification> alarms = new ArrayList<AlarmNotification>();
        HashMap<String, Object> processData = new HashMap<String, Object>();
        String titleId = (String)process.getContextInstance().getVariable(VAR_TITLE_ID);
        String titleBrief = (String)process.getContextInstance().getVariable(VAR_TITLE_BRIEF);
        Collection annotations = process.getProcessDefinition().getAnnotations();
        processData.put(VAR_TITLE_ID, titleId);
        processData.put(VAR_TITLE_BRIEF, titleBrief);
        processData.put(VAR_ANNOTATIONS, annotations);
        TaskMgmtInstance taskMgmtInstance = process.getTaskMgmtInstance();
        ArrayList tasks = new ArrayList();
        for (CustomToken token : process.findAllTokens()) {
            tasks.addAll(taskMgmtInstance.getUnfinishedTasks((Token)token));
        }
        for (TaskInstance task : tasks) {
            if (task.hasEnded()) continue;
            int seq = this.counter.incrementAndGet();
            AlarmNotification alarm = new AlarmNotification((Object)process.getId(), (long)seq, AlarmSeverity.Informational, "ManualTask", task.getCreate().getTime(), task.getName(), processData, task.getDescription());
            try {
                StringBuilder manualTaskUrl = new StringBuilder();
                manualTaskUrl.append(MANUAL_TASK_PORTAL_URL).append(process.getId()).append(":").append(task.getId());
                alarm.addAction(Intent.newInstance((IntentOperation)IntentOperation.ManualTask, (IntentAction)IntentAction.Hyperlink, (URI)new URI(manualTaskUrl.toString())));
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error occured building URL for AlarmNotification manual task.", (Throwable)e);
            }
            alarms.add(alarm);
        }
        return alarms;
    }
}

