/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.timer;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import com.tandbergtv.workflow.driver.timer.TokenTimer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class TimerManager
implements ITimerService {
    private ISchedulerService<Void> scheduler = new Scheduler("token-timers", 1, 1);
    private Map<Token, Future<Void>> futures = new ConcurrentHashMap<Token, Future<Void>>();
    private static final String SERVICE_NAME = "token-timers";
    private static final Logger LOGGER = Logger.getLogger(TimerManager.class);

    @Override
    public void addTimer(TokenTimer timer) {
        long delay = timer.getTimer().getDueDate().getTime() - System.currentTimeMillis();
        Future future = this.scheduler.schedule((Callable)timer, delay);
        this.futures.put(timer.getToken(), future);
        LOGGER.info((Object)(timer.getToken() + " added timer, total " + this.scheduler.count()));
    }

    @Override
    public void deleteTimer(Token token) {
        Future<Void> future = this.futures.get(token);
        if (future != null) {
            future.cancel(true);
            this.futures.remove(token);
            this.scheduler.purge();
        }
        LOGGER.info((Object)(token + " deleted timer, total " + this.scheduler.count()));
    }

    public void start() {
        this.scheduler.start();
    }

    public void stop() {
        this.futures.clear();
        this.scheduler.stop();
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }
}

