/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.internal;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.IArchivalService;
import com.tandbergtv.workflow.driver.template.IESDeleteService;
import com.tandbergtv.workflow.driver.template.internal.ESProcessDeleteService;
import com.tandbergtv.workflow.driver.template.internal.VersionBasedArchivalStrategy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class ArchivalService
implements IArchivalService {
    private ISchedulerService<Void> scheduler;
    private IESDeleteService processDeleter;
    private static final String SERVICE_NAME = "template-version";
    private static final long ONE_MINUTE_MILLIS = 60000L;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private long period;
    private long delay;
    private static final Logger LOGGER = Logger.getLogger(ArchivalService.class);

    public ArchivalService(ISchedulerService<Void> scheduler) {
        this.scheduler = scheduler;
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".archive");
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String timeofday = bundle.getString("version.service.timeofday");
        this.processDeleter = new ESProcessDeleteService();
        try {
            long time = formatter.parse(timeofday).getTime();
            long now = formatter.parse(formatter.format(new Date())).getTime();
            this.delay = time - now;
            if (this.delay < 0L) {
                this.delay += 86400000L;
            }
            LOGGER.debug((Object)(time / 60000L + ", " + now / 60000L));
        }
        catch (ParseException e) {
            this.delay = 0L;
        }
        try {
            this.period = Long.parseLong(bundle.getString("version.service.period")) * 60000L;
        }
        catch (Exception e) {
            this.period = 86400000L;
        }
        LOGGER.debug((Object)("Starting at " + timeofday + ", period = " + this.period / 3600000L + " hours"));
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.processDeleter.start();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ServiceRegistry registry = ServiceRegistry.getDefault();
                ITemplateLoaderService loader = (ITemplateLoaderService)registry.lookup(ITemplateLoaderService.class);
                IProcessSearchService search = (IProcessSearchService)registry.lookup(IProcessSearchService.class);
                new VersionBasedArchivalStrategy(loader, search, ArchivalService.this.processDeleter).archive();
            }
        }, this.delay, this.period);
    }

    public void stop() {
        this.processDeleter.stop();
    }

    @Override
    public void run(WorkflowTemplate template) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ITemplateLoaderService loader = (ITemplateLoaderService)registry.lookup(ITemplateLoaderService.class);
        IProcessSearchService search = (IProcessSearchService)registry.lookup(IProcessSearchService.class);
        new VersionBasedArchivalStrategy(loader, search, this.processDeleter).archive(template);
    }
}

