/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.util;

import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.DefaultResourceAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.ResourceAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.HeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.InitializationStrategy;
import com.tandbergtv.workflow.resourcemanager.util.StrategyClassLoadException;

public final class StrategyClassLoader {
    private StrategyClassLoader() {
    }

    public static ResourceAllocationStrategy loadAllocationStrategy(String className, ClassLoader loader) throws StrategyClassLoadException {
        Object strategyClass = StrategyClassLoader.loadStrategyClass(className, loader);
        if (!(strategyClass instanceof ResourceAllocationStrategy)) {
            String msg = "The Resource Allocation Strategy class: " + className + " does not implement: " + ResourceAllocationStrategy.class.getName();
            throw new StrategyClassLoadException(msg);
        }
        return (ResourceAllocationStrategy)strategyClass;
    }

    public static HeartBeatStrategy loadHeartBeatStrategy(String className, ClassLoader loader) throws StrategyClassLoadException {
        Object strategyClass = StrategyClassLoader.loadStrategyClass(className, loader);
        if (!(strategyClass instanceof HeartBeatStrategy)) {
            String msg = "The HeartBeat Strategy class: " + className + " does not implement: " + HeartBeatStrategy.class.getName();
            throw new StrategyClassLoadException(msg);
        }
        return (HeartBeatStrategy)strategyClass;
    }

    public static InitializationStrategy loadInitializationStrategy(String className, ClassLoader loader) throws StrategyClassLoadException {
        Object strategyClass = StrategyClassLoader.loadStrategyClass(className, loader);
        if (!(strategyClass instanceof InitializationStrategy)) {
            String msg = "The Initialization Strategy class: " + className + " does not implement: " + InitializationStrategy.class.getName();
            throw new StrategyClassLoadException(msg);
        }
        return (InitializationStrategy)strategyClass;
    }

    public static ResourceAllocationStrategy createDefaultResourceAllocationStrategy() {
        return new DefaultResourceAllocationStrategy();
    }

    public static HeartBeatStrategy createDefaultHeartBeatStrategy() {
        return null;
    }

    public static InitializationStrategy createDefaultInitializationStrategy() {
        return null;
    }

    private static Object loadStrategyClass(String className, ClassLoader loader) throws StrategyClassLoadException {
        try {
            Class<?> refClass = loader.loadClass(className);
            return refClass.newInstance();
        }
        catch (Exception ex) {
            String msg = "Failed to create instance of Strategy class: " + className;
            throw new StrategyClassLoadException(msg, ex);
        }
    }
}

