/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.event;

import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.event.IResourceConsumerAware;
import com.tandbergtv.workflow.resourcemanager.event.ResourceManagementEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AcquireResourceEvent
extends ResourceManagementEvent
implements IResourceConsumerAware {
    private static final long serialVersionUID = -6093683125276185415L;
    private Set<ProtectionKey> protectionKeys;
    private ResourceConsumerKey key;

    public AcquireResourceEvent(Object source, CustomToken token, Long resourceGroupId, String allocationKey) {
        super(source);
        if (token.getProtectionKeys() == null) {
            this.protectionKeys = Collections.emptySet();
        } else {
            HashSet<ProtectionKey> protectionKeysCopy = new HashSet<ProtectionKey>();
            for (ProtectionKey protectionKey : token.getProtectionKeys()) {
                ProtectionKey protectionKeyCopy = new ProtectionKey();
                protectionKeyCopy.setId(protectionKey.getId());
                protectionKeyCopy.setName(protectionKey.getName());
                protectionKeysCopy.add(protectionKeyCopy);
            }
            this.protectionKeys = protectionKeysCopy;
        }
        WorkflowProcess process = token.getProcessInstance();
        this.key = new ResourceConsumerKey(token.getId(), process.getId(), resourceGroupId, allocationKey, process.getPriority());
    }

    public Set<ProtectionKey> getProtectionKeys() {
        return this.protectionKeys;
    }

    @Override
    public ResourceConsumerKey getResourceConsumerKey() {
        return this.key;
    }

    public String toString() {
        return this.key + ", event ACQUIRE_RESOURCE";
    }
}

