/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager.util;

import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import org.apache.log4j.Logger;
import org.java.plugin.registry.Extension;

public class ResourceGroupExtensionParser {
    private static final Logger LOGGER = Logger.getLogger(ResourceGroupExtensionParser.class);

    private ResourceGroupExtensionParser() {
    }

    public static ResourceGroupDescriptor parse(Extension extension, ClassLoader classLoader) {
        LOGGER.debug((Object)"Entering method...");
        ResourceGroupDescriptor descriptor = new ResourceGroupDescriptor();
        descriptor.setExtensionId(extension.getId());
        descriptor.setPluginId(extension.getDeclaringPluginDescriptor().getId());
        Extension.Parameter param = extension.getParameter("systemId");
        if (param != null && param.rawValue().trim().length() > 0) {
            descriptor.setSystemId(param.valueAsString());
        }
        if ((param = extension.getParameter("name")) != null && param.rawValue().trim().length() > 0) {
            descriptor.setName(param.valueAsString());
        }
        if ((param = extension.getParameter("description")) != null && param.rawValue().trim().length() > 0) {
            descriptor.setDescription(param.valueAsString());
        }
        if ((param = extension.getParameter("isInternallyAcquired")) != null && param.rawValue().trim().length() > 0) {
            descriptor.setIsInternallyAcquired(param.valueAsBoolean());
        }
        if ((param = extension.getParameter("allocationStrategyClass")) != null && param.rawValue().trim().length() > 0) {
            descriptor.setAllocationStrategyClass(param.valueAsString());
        }
        if ((param = extension.getParameter("accessLevel")) != null && param.rawValue().trim().length() > 0) {
            descriptor.setAccessLevel(param.valueAsString());
        }
        if ((param = extension.getParameter("functionalType")) != null && param.rawValue().trim().length() > 0) {
            descriptor.setFunctionalType(param.valueAsString());
        }
        if ((param = extension.getParameter("imagePath")) != null && param.rawValue().trim().length() > 0) {
            descriptor.setImagePath(param.valueAsString());
        }
        descriptor.setClassLoader(classLoader);
        return descriptor;
    }
}

